//
//  AnnoTableViewCell.m
//  redstar
//
//  Created by admin on 15/11/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AnnoTableViewCell.h"

@implementation AnnoTableViewCell

- (void)setAnnounce:(AnnounceModel *)announce
{
    _announce = announce;
    
    
    NSString *str = [NSString stringWithFormat:@"<style> html{ font-size: 15px; color: #444444 } </style>%@", announce.content];
    NSAttributedString * attrStr = [[NSAttributedString alloc] initWithData:[str dataUsingEncoding:NSUnicodeStringEncoding] options:@{ NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType} documentAttributes:nil error:nil];
    self.titleLabel.attributedText = attrStr;
    
    
    //self.titleLabel.text = [NSString stringWithFormat:@"%@", announce.content];
    self.peopleLabel.text = [NSString stringWithFormat:@"发布人:%@ 发布日期:%@", announce.lastModify_operName ,announce.lastModify_time];
    
    if ([self.currentState isEqualToString:@"false"]) {
        if (announce.priority == 0) {
            self.stateLabel.text = @"低";
            self.bgImageView.image = [UIImage imageNamed:@"green_back"];
        } else if (announce.priority == 1) {
            self.stateLabel.text = @"中";
            self.bgImageView.image = [UIImage imageNamed:@"yellow_back"];
        } else {
            self.stateLabel.text = @"高";
            self.bgImageView.image = [UIImage imageNamed:@"red_back"];
        }
    } else if ([self.currentState isEqualToString:@"true"]) {
        self.bgImageView.image = [UIImage imageNamed:@"gray_back"];
        if (announce.priority == 0) {
            self.stateLabel.text = @"低";
        } else if (announce.priority == 1) {
            self.stateLabel.text = @"中";
        } else {
            self.stateLabel.text = @"高";
        }
    } else {
        if (announce.priority == 0) {
            self.stateLabel.text = @"低";
            self.bgImageView.image = [UIImage imageNamed:@"green_back"];
        } else if (announce.priority == 1) {
            self.stateLabel.text = @"中";
            self.bgImageView.image = [UIImage imageNamed:@"yellow_back"];
        } else {
            self.stateLabel.text = @"高";
            self.bgImageView.image = [UIImage imageNamed:@"red_back"];
        }
    }

}

- (UIImageView *)bgImageView
{
    if (!_bgImageView) {
        _bgImageView = [[UIImageView alloc] init];
        _bgImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_bgImageView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:22];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:overDateWidth];
        
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-22];
        [self.contentView addConstraint:overDateBottom];
    }
    return _bgImageView;
}


- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textColor = kLightBlack;
        _titleLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:17];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:55];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
        
    }
    return _titleLabel;
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _peopleLabel.textColor = kLightGray;
        _peopleLabel.font = [UIFont systemFontOfSize:13.0];
        [self.contentView addSubview:_peopleLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:55];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
        
    }
    return _peopleLabel;
}

- (UILabel *)stateLabel
{
    if (!_stateLabel) {
        _stateLabel = [[UILabel alloc] init];
        _stateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _stateLabel.textAlignment = NSTextAlignmentCenter;
        _stateLabel.textColor = [UIColor whiteColor];
        _stateLabel.font = [UIFont systemFontOfSize:14.0];
        [self.bgImageView addSubview:_stateLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:overDateBottom];
        
    }
    return _stateLabel;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
