//
//  CustomDropMenuView.h
//  redstar
//
//  Created by admin on 15/10/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <UIKit/UIKit.h>

@class CustomDropMenuView;

@protocol CustomDropMenuDelegate <NSObject>

@optional
- (void)dropdownMenuDidDismiss:(CustomDropMenuView *)menu;
- (void)dropdownMenuDidShow:(CustomDropMenuView *)menu;

@end

@interface CustomDropMenuView : UIView

@property (nonatomic, weak) id<CustomDropMenuDelegate> delegate;

+ (instancetype)defaultMenuView;

/**
 *  显示
 */
- (void)showFrom:(UIView *)from;
/**
 *  销毁
 */
- (void)dismiss;

/**
 *  内容
 */
@property (nonatomic, strong) UIView *content;
/**
 *  内容控制器
 */
@property (nonatomic, strong) UIViewController *contentController;
@property (nonatomic, assign) NSInteger count;

@end
