//
//  MineTableFooterView.m
//  redstar
//
//  Created by admin on 15/10/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MineTableFooterView.h"

@implementation MineTableFooterView
#pragma mark - init
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.backgroundColor = [UIColor greenColor];
    self.quitButton.backgroundColor = [UIColor orangeColor];
    
}

#pragma mark - lazy loading
- (UIButton *)quitButton
{
    if (!_quitButton) {
        _quitButton = [[UIButton alloc] init];
    }
    _quitButton.titleLabel.font = [UIFont systemFontOfSize:19.0];
    _quitButton.translatesAutoresizingMaskIntoConstraints = NO;
    _quitButton.layer.masksToBounds = YES;
    _quitButton.layer.cornerRadius = 5.0;
    [_quitButton setTitle:@"退出登录" forState:UIControlStateNormal];
    [self addSubview:_quitButton];
    
    
    NSLayoutConstraint *quitHeight = [NSLayoutConstraint constraintWithItem:_quitButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
    [_quitButton addConstraint:quitHeight];
    
    NSLayoutConstraint *quitLeft = [NSLayoutConstraint constraintWithItem:_quitButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:quitLeft];
    
    NSLayoutConstraint *quitRight = [NSLayoutConstraint constraintWithItem:_quitButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:quitRight];
    
    NSLayoutConstraint *quitBottom = [NSLayoutConstraint constraintWithItem:_quitButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-20];
    [self addConstraint:quitBottom];
    
    return _quitButton;
}


@end