//
//  LoginViewController.m
//  redstar
//
//  Created by admin on 15/10/22.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "LoginViewController.h"
#import "LoginView.h"
#import "CustomDropMenuView.h"

#import "RootTabBarController.h"

#import <AFNetworking.h>
#import "CommonFunc.h"

#define kUsernameTableViewCell @"usernameTableViewCell"

@interface LoginViewController () <CustomDropMenuDelegate, UITextFieldDelegate, UITableViewDelegate, UITableViewDataSource, UITabBarControllerDelegate> {
    BOOL isOpened; // 判断存取本地的tableView是否打开
}
@property (nonatomic, strong) LoginView *loginView;
@property (nonatomic, strong) NSMutableDictionary *allUserDict;

@property (nonatomic, strong) UITableView *dropTableView;
@property (nonatomic, strong) CustomDropMenuView *menu;

@property (nonatomic, strong) RootTabBarController *rootTBC;

@end

@implementation LoginViewController

#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    isOpened = NO;
    
    [self addAllClick];
   
    
    self.loginView.usernameTextFiled.delegate = self;
    
    // 初始化数组
    self.allUserDict = [NSMutableDictionary dictionaryWithObjectsAndKeys:@"thoradmin", @"admin", nil];
}

- (void)loadView
{
    self.view = self.loginView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods

- (void)addAllClick
{
    [self.loginView.loginButton addTarget:self action:@selector(loginButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.loginView.retrieveButton addTarget:self action:@selector(retrieveButtonClick:) forControlEvents:UIControlEventTouchUpInside];

    [self.loginView.registerButton addTarget:self action:@selector(registerButtonClick:) forControlEvents:UIControlEventTouchUpInside];
}

/**
 *  登录按钮
 */
- (void)loginButtonClick:(UIButton *)sender
{
    self.rootTBC = [[RootTabBarController alloc] init];
    [self presentViewController:_rootTBC animated:YES completion:nil];
    
//    AFHTTPSessionManager *session = [AFHTTPSessionManager manager];
//    session.requestSerializer = [AFJSONRequestSerializer serializer];
//    [session.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField:@"Content-Type"];
//    NSString *urlStr = [NSString stringWithFormat:@"%@%@%@", kRedStarURL, kLoginURL, self.loginView.usernameTextFiled.text];
//    NSString *password = self.loginView.passwordTextFiled.text;
//    NSString *passwordMD5 = [CommonFunc md5:password];
//    NSDictionary *parameters = @{@"authenticode":@"211534962",@"password":passwordMD5};
//    [session POST:urlStr parameters:parameters success:^(NSURLSessionDataTask *task, id responseObject) {
//        if ([responseObject[@"message"] isEqualToString:@"ok"]) {
//            
//            NSLog(@"response = %@", responseObject);
//            
//            NSUserDefaults *userDefault = [NSUserDefaults standardUserDefaults];
//            [userDefault setObject:self.loginView.usernameTextFiled.text forKey:@"username"];
//            [userDefault setObject:self.loginView.passwordTextFiled.text forKey:@"password"];
//            self.rootTBC = [[RootTabBarController alloc] init];
//            [self presentViewController:_rootTBC animated:YES completion:nil];
//        } else {
//            UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示" message:[NSString stringWithFormat:@"%@", responseObject[@"message"]] delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
//            [alertView show];
//        }
//    } failure:^(NSURLSessionDataTask *task, NSError *error) {
//        NSLog(@"error = %@", error);
//    }];

}


// 找回密码
- (void)retrieveButtonClick:(UIButton *)sender
{
    NSLog(@"找回密码");
}

// 找回密码
- (void)registerButtonClick:(UIButton *)sender
{
    NSLog(@"用户注册");
}

#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _allUserDict.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kUsernameTableViewCell];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kUsernameTableViewCell];
    }
    cell.textLabel.text = _allUserDict.allKeys[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [self tableView:self.dropTableView cellForRowAtIndexPath:indexPath];
    self.loginView.usernameTextFiled.text = cell.textLabel.text;
    NSString *key = _allUserDict.allKeys[indexPath.row];
    self.loginView.passwordTextFiled.text = _allUserDict[key];
    [_menu dismiss];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 40;
}


#pragma mark - UItextField Delegate
- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    if ([self.loginView.usernameTextFiled isFirstResponder]) {
        // 创建下拉菜单
        self.menu = [CustomDropMenuView defaultMenuView];
        _menu.delegate = self;
        _menu.count = _allUserDict.count;
        _menu.content = self.dropTableView;
        
        // 显示
        [_menu showFrom:self.loginView.usernameView];
    }
}

#pragma mark - layz loading
- (LoginView *)loginView
{
    if (!_loginView) {
        _loginView = [[LoginView alloc] init];
    }
    return _loginView;
}

- (UITableView *)dropTableView
{
    if (!_dropTableView) {
        _dropTableView = [[UITableView alloc] init];
    }
    [_dropTableView registerClass:[UITableViewCell class] forCellReuseIdentifier:kUsernameTableViewCell];
    _dropTableView.translatesAutoresizingMaskIntoConstraints = NO;
    _dropTableView.delegate = self;
    _dropTableView.dataSource = self;
    return _dropTableView;
}




@end
