//
//  LoginView.m
//  redstar
//
//  Created by admin on 15/10/22.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "LoginView.h"

@interface LoginView ()
@property (nonatomic, strong) UIView *passwordView;

@property (nonatomic, strong) UIView *lineView1;
@property (nonatomic, strong) UIView *lineView2;

@property (nonatomic, strong) UIImageView *usernameImageView;
@property (nonatomic, strong) UIImageView *passwordImageView;
@end

@implementation LoginView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self addSubviews];
        self.backgroundColor = [UIColor colorWithRed:163 / 255.0 green:215 / 255.0 blue:248 / 255.0 alpha:1.0];
    }
    return self;
}

#pragma mark - Private Methods
- (void)addSubviews
{
    self.usernameView.backgroundColor = [UIColor whiteColor];
    self.passwordView.backgroundColor = [UIColor whiteColor];
    
    self.lineView1.backgroundColor = kSeparateLineColor;
    self.lineView2.backgroundColor = kSeparateLineColor;
    
    [self.loginButton setTitle:@"登 录" forState:UIControlStateNormal];
    
    self.usernameImageView.image = [UIImage imageNamed:@"username_icon"];
    self.passwordImageView.image = [UIImage imageNamed:@"password_icon"];
    
    self.usernameTextFiled.clearButtonMode = UITextFieldViewModeAlways;
    self.passwordTextFiled.clearButtonMode = UITextFieldViewModeAlways;

    
    [self.retrieveButton setTitle:@"找回密码" forState:UIControlStateNormal];
    [self.registerButton setTitle:@"用户注册" forState:UIControlStateNormal];

}

#pragma mark - layz loading
- (UIView *)usernameView
{
    if (!_usernameView) {
        _usernameView = [[UIView alloc] init];
    }
    _usernameView.layer.cornerRadius = 5;
    _usernameView.layer.masksToBounds = YES;
    _usernameView.layer.borderWidth = 1;
    _usernameView.layer.borderColor = kUsernameBorderColor;
    _usernameView.translatesAutoresizingMaskIntoConstraints = NO;
    [self addSubview:_usernameView];
    
    // 顶端
    NSLayoutConstraint *usenameTop = [NSLayoutConstraint constraintWithItem:_usernameView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:210];
    [self addConstraint:usenameTop];
    
    // 左边
    NSLayoutConstraint *usenameLeft = [NSLayoutConstraint constraintWithItem:_usernameView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:usenameLeft];
    
    // 右边
    NSLayoutConstraint *usenameRight = [NSLayoutConstraint constraintWithItem:_usernameView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:usenameRight];
    
    // 高度
    NSLayoutConstraint *usenameHeight = [NSLayoutConstraint constraintWithItem:_usernameView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [_usernameView addConstraint:usenameHeight];
    
    return _usernameView;
}

- (UIView *)passwordView
{
    if (!_passwordView) {
        _passwordView = [[UIView alloc] init];
    }
    _passwordView.layer.cornerRadius = 5;
    _passwordView.layer.masksToBounds = YES;
    _passwordView.layer.borderWidth = 1;
    _passwordView.layer.borderColor = kPasswordBorderColor;
    _passwordView.translatesAutoresizingMaskIntoConstraints = NO;
    [self addSubview:_passwordView];
    
    // 顶端
    NSLayoutConstraint *passwordTop = [NSLayoutConstraint constraintWithItem:_passwordView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:15];
    [self addConstraint:passwordTop];
    
    // 左边
    NSLayoutConstraint *passwordLeft = [NSLayoutConstraint constraintWithItem:_passwordView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:passwordLeft];
    
    // 右边
    NSLayoutConstraint *passwordRight = [NSLayoutConstraint constraintWithItem:_passwordView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:passwordRight];
    
    // 高度
    NSLayoutConstraint *passwordHeight = [NSLayoutConstraint constraintWithItem:_passwordView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [_passwordView addConstraint:passwordHeight];
    
    return _passwordView;
}

- (UIImageView *)usernameImageView
{
    if (!_usernameImageView) {
        _usernameImageView = [[UIImageView alloc] init];
    }
    _usernameImageView.translatesAutoresizingMaskIntoConstraints = NO;
    [self.usernameView addSubview:_usernameImageView];
    
    // 顶端
    NSLayoutConstraint *usernameImageViewTop = [NSLayoutConstraint constraintWithItem:_usernameImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeTop multiplier:1.0 constant:14];
    [self.usernameView addConstraint:usernameImageViewTop];
    
    // 左边
    NSLayoutConstraint *usernameImageViewLeft = [NSLayoutConstraint constraintWithItem:_usernameImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:14];
    [self.usernameView addConstraint:usernameImageViewLeft];
    
    // 底部
    NSLayoutConstraint *usernameImageViewHeight = [NSLayoutConstraint constraintWithItem:_usernameImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:21];
    [self.usernameView addConstraint:usernameImageViewHeight];
    
    // 宽度
    NSLayoutConstraint *usernameImageViewWidth = [NSLayoutConstraint constraintWithItem:_usernameImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:24];
    [_usernameImageView addConstraint:usernameImageViewWidth];
    
    
    return _usernameImageView;
}

- (UIImageView *)passwordImageView
{
    if (!_passwordImageView) {
        _passwordImageView = [[UIImageView alloc] init];
    }
    _passwordImageView.translatesAutoresizingMaskIntoConstraints = NO;
    [self.passwordView addSubview:_passwordImageView];
    
    // 顶端
    NSLayoutConstraint *passwordImageViewTop = [NSLayoutConstraint constraintWithItem:_passwordImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeTop multiplier:1.0 constant:14];
    [self.passwordView addConstraint:passwordImageViewTop];
    
    // 左边
    NSLayoutConstraint *passwordImageViewLeft = [NSLayoutConstraint constraintWithItem:_passwordImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:17];
    [self.passwordView addConstraint:passwordImageViewLeft];
    
    // 底部
    NSLayoutConstraint *passwordImageViewBottom = [NSLayoutConstraint constraintWithItem:_passwordImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:23];
    [self.passwordView addConstraint:passwordImageViewBottom];
    
    // 宽度
    NSLayoutConstraint *passwordImageViewWidth = [NSLayoutConstraint constraintWithItem:_passwordImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:19];
    [_passwordImageView addConstraint:passwordImageViewWidth];

    return _passwordImageView;
}

- (UIView *)lineView1
{
    if (!_lineView1) {
        _lineView1 = [[UIView alloc] init];
        _lineView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.usernameView addSubview:_lineView1];
        
        // 顶端
        NSLayoutConstraint *line1Top = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.usernameView addConstraint:line1Top];
        
        // 左边
        NSLayoutConstraint *line1Left = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:50];
        [self.usernameView addConstraint:line1Left];
        
        // 底部
        NSLayoutConstraint *line1Bottom = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:_usernameView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.usernameView addConstraint:line1Bottom];
        
        // 宽度
        NSLayoutConstraint *line1Width = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [_lineView1 addConstraint:line1Width];
    }
    return _lineView1;
}

- (UIView *)lineView2
{
    if (!_lineView2) {
        _lineView2 = [[UIView alloc] init];
        _lineView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self.passwordView addSubview:_lineView2];
        
        // 顶端
        NSLayoutConstraint *line2Top = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.passwordView addConstraint:line2Top];
        
        // 左边
        NSLayoutConstraint *line2Left = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:50];
        [self.passwordView addConstraint:line2Left];
        
        // 底部
        NSLayoutConstraint *line2Bottom = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.passwordView addConstraint:line2Bottom];
        
        // 宽度
        NSLayoutConstraint *line2Width = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [_lineView2 addConstraint:line2Width];
    }
    return _lineView2;
}

- (UITextField *)usernameTextFiled
{
    if (!_usernameTextFiled) {
        _usernameTextFiled = [[UITextField alloc] init];
    }
    _usernameTextFiled.placeholder = @"请输入用户名";
    [_usernameTextFiled setValue:[UIFont boldSystemFontOfSize:16] forKeyPath:@"_placeholderLabel.font"];
    _usernameTextFiled.translatesAutoresizingMaskIntoConstraints = NO;
    [self.usernameView addSubview:_usernameTextFiled];
    
    // 顶端
    NSLayoutConstraint *usernameTextFiledTop = [NSLayoutConstraint constraintWithItem:_usernameTextFiled attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.usernameView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.usernameView addConstraint:usernameTextFiledTop];
    
    // 左边
    NSLayoutConstraint *usernameTextFiledLeft = [NSLayoutConstraint constraintWithItem:_usernameTextFiled attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.usernameImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:25];
    [self.usernameView addConstraint:usernameTextFiledLeft];
    
    // 右边
    NSLayoutConstraint *usernameTextFiledRight = [NSLayoutConstraint constraintWithItem:_usernameTextFiled attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.usernameView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.usernameView addConstraint:usernameTextFiledRight];
    
    // 底部
    NSLayoutConstraint *usernameTextFiledBottom = [NSLayoutConstraint constraintWithItem:_usernameTextFiled attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.usernameView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.usernameView addConstraint:usernameTextFiledBottom];

    return _usernameTextFiled;
}

- (UITextField *)passwordTextFiled
{
    if (!_passwordTextFiled) {
        _passwordTextFiled = [[UITextField alloc] init];
    }
    _passwordTextFiled.secureTextEntry = YES;
    _passwordTextFiled.placeholder = @"请输入密码";
    [_passwordTextFiled setValue:[UIFont boldSystemFontOfSize:16] forKeyPath:@"_placeholderLabel.font"];
    _passwordTextFiled.translatesAutoresizingMaskIntoConstraints = NO;
    [self.passwordView addSubview:_passwordTextFiled];
    
    // 顶端
    NSLayoutConstraint *passwordTextFiledTop = [NSLayoutConstraint constraintWithItem:_passwordTextFiled attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.passwordView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.passwordView addConstraint:passwordTextFiledTop];
    
    // 左边
    NSLayoutConstraint *passwordTextFiledLeft = [NSLayoutConstraint constraintWithItem:_passwordTextFiled attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.passwordImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:25];
    [self.passwordView addConstraint:passwordTextFiledLeft];
    
    // 右边
    NSLayoutConstraint *passwordTextFiledRight = [NSLayoutConstraint constraintWithItem:_passwordTextFiled attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.passwordView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.passwordView addConstraint:passwordTextFiledRight];
    
    // 底部
    NSLayoutConstraint *passwordTextFiledBottom = [NSLayoutConstraint constraintWithItem:_passwordTextFiled attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.passwordView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.passwordView addConstraint:passwordTextFiledBottom];
    
    return _passwordTextFiled;
}

- (UIButton *)loginButton
{
    if (!_loginButton) {
        _loginButton = [[UIButton alloc] init];
    }
    // 设置圆角
    _loginButton.layer.cornerRadius = 5;
    _loginButton.layer.masksToBounds = YES;
    _loginButton.translatesAutoresizingMaskIntoConstraints = NO;
    _loginButton.backgroundColor = kLoginButtonBackGroundColor;
    [_loginButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    _loginButton.titleLabel.font = [UIFont systemFontOfSize:20.0];
    [self addSubview:_loginButton];
    
    // 顶端
    NSLayoutConstraint *loginTop = [NSLayoutConstraint constraintWithItem:_loginButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_passwordView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:15];
    [self addConstraint:loginTop];
    
    // 左边
    NSLayoutConstraint *loginLeft = [NSLayoutConstraint constraintWithItem:_loginButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:loginLeft];
    
    // 右边
    NSLayoutConstraint *loginRight = [NSLayoutConstraint constraintWithItem:_loginButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:loginRight];
    
    // 高度
    NSLayoutConstraint *loginHeight = [NSLayoutConstraint constraintWithItem:_loginButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [_loginButton addConstraint:loginHeight];
    
    return _loginButton;
}

- (UIButton *)retrieveButton
{
    if (!_retrieveButton) {
        _retrieveButton = [[UIButton alloc] init];
    }
    _retrieveButton.translatesAutoresizingMaskIntoConstraints = NO;
    _retrieveButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
    [self addSubview:_retrieveButton];
    // 顶端
    NSLayoutConstraint *retrieveInHeight = [NSLayoutConstraint constraintWithItem:_retrieveButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [self addConstraint:retrieveInHeight];
    
    // 左边
    NSLayoutConstraint *retrieveInWidth = [NSLayoutConstraint constraintWithItem:_retrieveButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
    [_retrieveButton addConstraint:retrieveInWidth];
    
    // 右边
    NSLayoutConstraint *retrieveInLeft = [NSLayoutConstraint constraintWithItem:_retrieveButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:15];
    [self addConstraint:retrieveInLeft];
    
    // 底部
    NSLayoutConstraint *retrieveInBottom = [NSLayoutConstraint constraintWithItem:_retrieveButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:retrieveInBottom];
    
    return _retrieveButton;
}

- (UIButton *)registerButton
{
    if (!_registerButton) {
        _registerButton = [[UIButton alloc] init];
    }
    _registerButton.translatesAutoresizingMaskIntoConstraints = NO;
    _registerButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
    [self addSubview:_registerButton];
    // 顶端
    NSLayoutConstraint *retrieveInHeight = [NSLayoutConstraint constraintWithItem:_registerButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [_registerButton addConstraint:retrieveInHeight];
    
    // 左边
    NSLayoutConstraint *retrieveInWidth = [NSLayoutConstraint constraintWithItem:_registerButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
    [_registerButton addConstraint:retrieveInWidth];
    
    // 右边
    NSLayoutConstraint *retrieveInRight = [NSLayoutConstraint constraintWithItem:_registerButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
    [self addConstraint:retrieveInRight];
    
    // 底部
    NSLayoutConstraint *retrieveInBottom = [NSLayoutConstraint constraintWithItem:_registerButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:retrieveInBottom];
    
    return _registerButton;
}

@end
