//
//  HomeViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeViewController.h"
#import "HomeHeaderView.h"
#import "HomeFunctionCell.h"
#import "NewAnnounceCell.h"

#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "OnLineViewController.h"
#import "PictureViewController.h"
#import "QuestionViewController.h"

#define kNewAnnounceCell @"NewAnnounceTableViewCell"
#define kHomeFunctionCell @"HomeFunctionCell"

@interface HomeViewController () <UITableViewDelegate, UITableViewDataSource, UIScrollViewDelegate>
// 当前视图
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) HomeHeaderView *headView;

@property (nonatomic, strong) NSArray *titleArray; // section标题
@property (nonatomic, strong) NSArray *announeArray; // 公告内容
@end

@implementation HomeViewController
#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"首页"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    // 初始化容器
    self.titleArray = [NSArray arrayWithObjects:@"最新公告", @"常用功能", nil];
    self.announeArray = [NSArray arrayWithObjects:@"关于展开10月口碑巡检的说明", @"迎2015十一大促活动启动", @"9月口碑巡检结果排名已公布", nil];
    
    [self setupTableView];
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = NO;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - Private Methods
- (void)setupTableView
{
    self.headView = [[HomeHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 125)];
    self.tableView.tableHeaderView = self.headView;
}

- (void)moreButtonClick:(UIButton *)sender
{
    NSLog(@"查看全部公告···");
}

// 在线抽查或任务处理
- (void)onLineSamplingClick:(UIButton *)sender
{
    OnLineViewController *onLineVC = [[OnLineViewController alloc] init];
    self.hidesBottomBarWhenPushed = YES;
    [self.navigationController pushViewController:onLineVC animated:YES];
}

// 口碑列表 或口碑排名
- (void)wordOfMouthClick:(UIButton *)sender
{
    InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
    self.hidesBottomBarWhenPushed = YES;
    [self.navigationController pushViewController:inspectListVC animated:YES];
    
//    RankingListViewController *rankListVC = [[RankingListViewController alloc] init];
//    self.hidesBottomBarWhenPushed = YES;
//    [self.navigationController pushViewController:rankListVC animated:YES];
}

// 问题与知识
- (void)questionClick:(UIButton *)sender
{
    QuestionViewController *questionVC = [[QuestionViewController alloc] init];
    self.hidesBottomBarWhenPushed = YES;
    [self.navigationController pushViewController:questionVC animated:YES];
}

- (void)standardClick:(UIButton *)sender
{
    
}

// 图说口碑
- (void)pictureClick:(UIButton *)sender
{
    PictureViewController *pictureVC = [[PictureViewController alloc] init];
    self.hidesBottomBarWhenPushed = YES;
    [self.navigationController pushViewController:pictureVC animated:YES];
}

- (void)caseClick:(UIButton *)sender
{
    
}




#pragma mark - TableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _titleArray.count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 3;
    } else {
        return 1;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        NewAnnounceCell *cell=[tableView dequeueReusableCellWithIdentifier:kNewAnnounceCell];
        if (!cell) {
            cell = [[NewAnnounceCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kNewAnnounceCell];
        }
        cell.announceLabel.text = _announeArray[indexPath.row];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;

    } else {
        HomeFunctionCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeFunctionCell];
        if (!cell) {
            cell = [[HomeFunctionCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeFunctionCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        [cell.onLineSamplingBtn addTarget:self action:@selector(onLineSamplingClick:) forControlEvents:UIControlEventTouchUpInside];
        [cell.wordOfMouthBtn addTarget:self action:@selector(wordOfMouthClick:) forControlEvents:UIControlEventTouchUpInside];
        [cell.questionBtn addTarget:self action:@selector(questionClick:) forControlEvents:UIControlEventTouchUpInside];
        [cell.standardBtn addTarget:self action:@selector(standardClick:) forControlEvents:UIControlEventTouchUpInside];
        [cell.pictureBtn addTarget:self action:@selector(pictureClick:) forControlEvents:UIControlEventTouchUpInside];
        [cell.caseBtn addTarget:self action:@selector(caseClick:) forControlEvents:UIControlEventTouchUpInside];
        return cell;
    }
    
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        return 40;
    } else {
        return 240;
    }
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 36;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = kSectionBackGroundColor;
    // 创建标题label
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.textColor = kHomeSectionTitleTextColor;
    titleLabel.font = [UIFont systemFontOfSize:17.0];
    titleLabel.text = _titleArray[section];
    [sectionView addSubview:titleLabel];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
    [sectionView addConstraint:titleLabelWidth];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    
    
    if (section == 0) {
         // 查看更多按钮
        UIButton *moreButton = [[UIButton alloc] init];
        moreButton.translatesAutoresizingMaskIntoConstraints = NO;
        [moreButton setTitle:@"查看全部" forState:UIControlStateNormal];
        [moreButton setTitleColor:kMoreButtonTextColor forState:UIControlStateNormal];
        [moreButton addTarget:self action:@selector(moreButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        moreButton.titleLabel.font = [UIFont systemFontOfSize:13.0];
        [sectionView addSubview:moreButton];
        
        // 箭头Iamge
        UIImageView *arrowIamgeView = [[UIImageView alloc] init];
        arrowIamgeView.image = [UIImage imageNamed:@"arrow_right"];
        arrowIamgeView.translatesAutoresizingMaskIntoConstraints = NO;
        [sectionView addSubview:arrowIamgeView];
        
        // moreButton布局
        NSLayoutConstraint *moreButtonTop = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
        [sectionView addConstraint:moreButtonTop];
        
        NSLayoutConstraint *moreButtonRight = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowIamgeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [sectionView addConstraint:moreButtonRight];
        
        NSLayoutConstraint *moreButtonWidth = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [sectionView addConstraint:moreButtonWidth];
        
        NSLayoutConstraint *moreButtonBottom = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:moreButtonBottom];
        
        // arrowIamgeView布局
        NSLayoutConstraint *arrowIamgeViewTop = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
        [sectionView addConstraint:arrowIamgeViewTop];
        
        NSLayoutConstraint *arrowIamgeViewRight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [sectionView addConstraint:arrowIamgeViewRight];
        
        NSLayoutConstraint *arrowIamgeViewWidth = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
        [sectionView addConstraint:arrowIamgeViewWidth];
        
        NSLayoutConstraint *arrowIamgeViewHeight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
        [sectionView addConstraint:arrowIamgeViewHeight];
    } else {
        
    }
    
    return sectionView;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [_tableView registerClass:[NewAnnounceCell class] forCellReuseIdentifier:kNewAnnounceCell];
        [_tableView registerClass:[HomeFunctionCell class] forCellReuseIdentifier:kHomeFunctionCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

@end
