//
//  HomeHeaderView.m
//  redstar
//
//  Created by admin on 15/10/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeHeaderView.h"
#define ImageCount 5

@interface HomeHeaderView () <UIScrollViewDelegate>

@property (nonatomic,assign) BOOL isDragging;               //是否正在拖动
@property (nonatomic,strong) NSTimer *timer;                 //设置动画


@end

@implementation HomeHeaderView

#pragma mark - init
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = kMineBackGroundColor;
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    _isDragging = NO;
    // 天气label
    self.weatherLabel.text = @"上海 ⛅️ 多云转晴 21-29℃";
    
    CGFloat width = self.scrollView.frame.size.width;
    CGFloat height = self.scrollView.frame.size.height;
    _scrollView.contentSize = CGSizeMake(ImageCount  * width, 0);
    
    for (int i = 0; i < ImageCount; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        CGFloat imageX = i * width;
        CGFloat imageY = 0.f;
        imageView.frame = CGRectMake(imageX, imageY, width, height);
        imageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"0%d", i]];
        imageView.userInteractionEnabled = YES;
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapGRClick:)];
        [imageView addGestureRecognizer:tapGR];
        
        [_scrollView addSubview:imageView];
    }
    
    
    
    
    //  设置时钟动画 定时器
    self.timer = [NSTimer scheduledTimerWithTimeInterval:1.5f target:self selector:@selector(update:) userInfo:nil repeats:YES];
    //  将定时器添加到主线程
    [[NSRunLoop mainRunLoop] addTimer:self.timer forMode:NSRunLoopCommonModes];

}

- (void)update:(NSTimer *)timer{
    //定时移动
    if (_isDragging == YES) {
        return ;
    }
    CGPoint offSet = self.scrollView.contentOffset;
    if (offSet.x == 0) {
        offSet.x = _scrollView.frame.size.width;
    } else if (offSet.x <= (ImageCount - 2) * _scrollView.frame.size.width){
        offSet.x +=_scrollView.frame.size.width;
    } else {
        offSet.x = 0;
    }
    [self.scrollView setContentOffset:offSet animated:YES];

    
}

- (void)tapGRClick:(UITapGestureRecognizer *)sender
{
    NSLog(@"轮播图点击···");
}


#pragma mark - UIScrollView Delegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
   
}

- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView
{
    _isDragging = YES;
}
//  停止滚动
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    _isDragging = NO;
}

#pragma mark - lazy loading
- (UIScrollView *)scrollView
{
    if (!_scrollView) {
        _scrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height)];
        _scrollView.bounces = NO;
        _scrollView.pagingEnabled = YES;
        _scrollView.delegate = self;
        _scrollView.showsHorizontalScrollIndicator = NO;
        _scrollView.showsVerticalScrollIndicator = NO;
        [self addSubview:_scrollView];
    }
    return _scrollView;
}

- (UILabel *)weatherLabel
{
    if (!_weatherLabel) {
        _weatherLabel = [[UILabel alloc] init];
        _weatherLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _weatherLabel.textAlignment = NSTextAlignmentRight;
        _weatherLabel.textColor = [UIColor whiteColor];
        _weatherLabel.font = [UIFont systemFontOfSize:15.0];
        [_weatherLabel setShadowColor:[UIColor blackColor]];
        [_weatherLabel setShadowOffset:CGSizeMake(1, 1)];
        [self insertSubview:_weatherLabel aboveSubview:self.scrollView];
        
        NSLayoutConstraint *weatherHeight = [NSLayoutConstraint constraintWithItem:_weatherLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [_weatherLabel addConstraint:weatherHeight];
        
        NSLayoutConstraint *weatherRight = [NSLayoutConstraint constraintWithItem:_weatherLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self addConstraint:weatherRight];
        
        NSLayoutConstraint *weatherBottom = [NSLayoutConstraint constraintWithItem:_weatherLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:weatherBottom];
    }
    return _weatherLabel;
}
@end
