//
//  NewAnnounceCell.m
//  redstar
//
//  Created by admin on 15/10/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "NewAnnounceCell.h"

@implementation NewAnnounceCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

#pragma mark - Private Methods
- (void)setup
{
    self.announceLabel.textColor = kAnnounceTextColor;
    self.pointLabel.text = @"···";
}

#pragma mark - Lazy Loading
- (UILabel *)announceLabel
{
    if (!_announceLabel) {
        _announceLabel = [[UILabel alloc] init];
        _announceLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _announceLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_announceLabel];
        
        NSLayoutConstraint *announceTop = [NSLayoutConstraint constraintWithItem:_announceLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:announceTop];
        
        NSLayoutConstraint *announceLeft = [NSLayoutConstraint constraintWithItem:_announceLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:announceLeft];
        
        NSLayoutConstraint *announceRight = [NSLayoutConstraint constraintWithItem:_announceLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.pointLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:announceRight];
        
        
        NSLayoutConstraint *announceBottom = [NSLayoutConstraint constraintWithItem:_announceLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:announceBottom];
    }
    return _announceLabel;
}

- (UILabel *)pointLabel
{
    if (!_pointLabel) {
        _pointLabel = [[UILabel alloc] init];
        _pointLabel.textColor = kPointColor;
        _pointLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _pointLabel.font = [UIFont systemFontOfSize:15.0];
        
        [self.contentView addSubview:_pointLabel];
        
        NSLayoutConstraint *pointTop = [NSLayoutConstraint constraintWithItem:_pointLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:pointTop];
        
        NSLayoutConstraint *pointWidth = [NSLayoutConstraint constraintWithItem:_pointLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:pointWidth];
        
        NSLayoutConstraint *pointRight = [NSLayoutConstraint constraintWithItem:_pointLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:pointRight];
        
        
        NSLayoutConstraint *pointBottom = [NSLayoutConstraint constraintWithItem:_pointLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:pointBottom];
        
    }
    return _pointLabel;
}
@end
