//
//  HomeFunctionCell.m
//  redstar
//
//  Created by admin on 15/10/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeFunctionCell.h"

@interface HomeFunctionCell ()
@property (nonatomic, strong) UIView *lineView;
@end

@implementation HomeFunctionCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

#pragma mark - Private Methods
- (void)setup
{
    [self.onLineSamplingBtn setTitle:@"在线抽查" forState:UIControlStateNormal];
    [self.wordOfMouthBtn setTitle:@"口碑报告" forState:UIControlStateNormal];
    [self.standardBtn setTitle:@"口碑标准" forState:UIControlStateNormal];
    [self.pictureBtn setTitle:@"图说口碑" forState:UIControlStateNormal];
    [self.questionBtn setTitle:@"问题与知识" forState:UIControlStateNormal];
    [self.caseBtn setTitle:@"优秀案例" forState:UIControlStateNormal];
    self.lineView.backgroundColor = kSeparateLineViewColor;
}


#pragma mark - lazy loading
- (HomeCellItem *)onLineSamplingBtn
{
    if (!_onLineSamplingBtn) {
        _onLineSamplingBtn = [[HomeCellItem alloc] init];
        _onLineSamplingBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_onLineSamplingBtn setImage:[UIImage imageNamed:@"task_online"] forState:UIControlStateNormal];
        [self.contentView addSubview:_onLineSamplingBtn];
        
        NSLayoutConstraint *onLineSamplingTop = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:onLineSamplingTop];
        
        NSLayoutConstraint *onLineSamplingLeft = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:onLineSamplingLeft];
        
        NSLayoutConstraint *onLineSamplingWidth = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.wordOfMouthBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:onLineSamplingWidth];
        
        NSLayoutConstraint *onLineSamplingRight = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.wordOfMouthBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:onLineSamplingRight];
        
        NSLayoutConstraint *onLineSamplingHeight = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:119];
        [self.contentView addConstraint:onLineSamplingHeight];
        
        
        
    }
    return _onLineSamplingBtn;
}

- (HomeCellItem *)wordOfMouthBtn
{
    if (!_wordOfMouthBtn) {
        _wordOfMouthBtn = [[HomeCellItem alloc] init];
        [_wordOfMouthBtn setImage:[UIImage imageNamed:@"praise_report"] forState:UIControlStateNormal];
        _wordOfMouthBtn.translatesAutoresizingMaskIntoConstraints = NO;

        [self.contentView addSubview:_wordOfMouthBtn];
        
        NSLayoutConstraint *wordOfMouthTop = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:wordOfMouthTop];
        
        NSLayoutConstraint *wordOfMouthRight = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.standardBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:wordOfMouthRight];
        
        NSLayoutConstraint *wordOfMouthWithd = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.standardBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:wordOfMouthWithd];
        
        NSLayoutConstraint *wordOfMouthHeight = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_onLineSamplingBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.contentView addConstraint:wordOfMouthHeight];
        
    }
    return _wordOfMouthBtn;
}

- (HomeCellItem *)standardBtn
{
    if (!_standardBtn) {
        _standardBtn = [[HomeCellItem alloc] init];
        [_standardBtn setImage:[UIImage imageNamed:@"praise_standard"] forState:UIControlStateNormal];
        _standardBtn.translatesAutoresizingMaskIntoConstraints = NO;

        [self.contentView addSubview:_standardBtn];
        
        NSLayoutConstraint *standardRight = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:standardRight];
        
        
        NSLayoutConstraint *standardHeight = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_wordOfMouthBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.contentView addConstraint:standardHeight];
        
        
        NSLayoutConstraint *standardTop = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:standardTop];
        
    }
    return _standardBtn;
}

- (HomeCellItem *)pictureBtn
{
    if (!_pictureBtn) {
        _pictureBtn = [[HomeCellItem alloc] init];
        [_pictureBtn setImage:[UIImage imageNamed:@"praise_image"] forState:UIControlStateNormal];
        _pictureBtn.translatesAutoresizingMaskIntoConstraints = NO;

        [self.contentView addSubview:_pictureBtn];
        
        NSLayoutConstraint *pictureTop = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.onLineSamplingBtn attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:pictureTop];
        
        NSLayoutConstraint *pictureLeft = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:pictureLeft];
       
        
        NSLayoutConstraint *pictureRight = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.questionBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:pictureRight];
        
        NSLayoutConstraint *pictureWidth = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.questionBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:pictureWidth];
        
        NSLayoutConstraint *pictureHeight = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.onLineSamplingBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.contentView addConstraint:pictureHeight];
        
    }
    return _pictureBtn;
}

- (HomeCellItem *)questionBtn
{
    if (!_questionBtn) {
        _questionBtn = [[HomeCellItem alloc] init];
        [_questionBtn setImage:[UIImage imageNamed:@"question_problem"] forState:UIControlStateNormal];
        _questionBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_questionBtn];
        
        NSLayoutConstraint *questionWidth = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.caseBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:questionWidth];
        
        NSLayoutConstraint *questionRight = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.caseBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:questionRight];
        
        NSLayoutConstraint *questionTop = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_pictureBtn attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:questionTop];
        
        NSLayoutConstraint *questionHeight = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_pictureBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.contentView addConstraint:questionHeight];
    }
    return _questionBtn;
}

- (HomeCellItem *)caseBtn
{
    if (!_caseBtn) {
        _caseBtn = [[HomeCellItem alloc] init];
        [_caseBtn setImage:[UIImage imageNamed:@"excellent_case"] forState:UIControlStateNormal];
        _caseBtn.translatesAutoresizingMaskIntoConstraints = NO;

        [self.contentView addSubview:_caseBtn];
        
        NSLayoutConstraint *caseTop = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_questionBtn attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:caseTop];
        
        NSLayoutConstraint *caseRight = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:caseRight];
        
        NSLayoutConstraint *caseHeight = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_questionBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.contentView addConstraint:caseHeight];
        
    }
    return _caseBtn;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc] init];
        _lineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_lineView];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:lineViewLeft];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewHeight = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:2];
        [self.contentView addConstraint:lineViewHeight];
    }
    return _lineView;
}


@end
