//
//  RankingListViewController.m
//  redstar
//
//  Created by admin on 15/10/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankingListViewController.h"
#import "RankingListCell.h"
#import "RankDetailViewController.h"

#define kRankingCell @"RankingTableViewCell"

@interface RankingListViewController () <UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) UIView *headView;
@property (nonatomic, strong) UIView *lineView1;
@property (nonatomic, strong) NSMutableDictionary *selectedIndexes;

@end

@implementation RankingListViewController

#pragma mark - ViewDidLoad
- (void)viewDidLoad {
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑排名"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    if([[[UIDevice currentDevice]systemVersion]floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
    }
    
    // 初始化容器
    self.selectedIndexes = [[NSMutableDictionary alloc] init];

    [self addTableViews];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = YES;
}

#pragma mark - Private Methods


- (void)addTableViews
{
    [self.tableView registerClass:[RankingListCell class] forCellReuseIdentifier:kRankingCell];
    
    self.tableView.tableHeaderView = self.headView;
    self.pointLabel1.text = @"月度排名";
    self.pointLabel2.text = @"参与商家数量";
    self.lineView.backgroundColor = kSeparateLineColor;
    self.lineView1.backgroundColor = kSeparateLineColor;
    self.shoppingCountLabel.textAlignment = NSTextAlignmentCenter;
    [self.dateButton addTarget:self action:@selector(changeDateClick:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)changeDateClick:(DateButton *)sender
{
    
}

- (BOOL)cellIsSelected:(NSIndexPath *)indexPath {
    // Return whether the cell at the specified index path is selected or not
    NSNumber *selectedIndex = [_selectedIndexes objectForKey:indexPath];
    return selectedIndex == nil ? FALSE : [selectedIndex boolValue];
}

- (void)loadMoreInfo:(UIButton *)sender
{
    RankingListCell * cell = (RankingListCell *)[[sender superview] superview];
    cell.isDrop = !cell.isDrop;
    NSIndexPath * path = [self.tableView indexPathForCell:cell];
    
    [_tableView deselectRowAtIndexPath:path animated:TRUE];
    
    BOOL isSelected = ![self cellIsSelected:path];
    
    NSNumber *selectedIndex = [NSNumber numberWithBool:isSelected];
    [_selectedIndexes setObject:selectedIndex forKey:path];
    
    if (cell.isDrop) {
        
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(M_PI / 2);
        }];
        
        
        cell.someoneLabel = [[UILabel alloc] init];
        cell.someoneLabel.text = @"集团领导某总";
        cell.someoneLabel.font = [UIFont systemFontOfSize:15.0];
        cell.someoneLabel.textAlignment = NSTextAlignmentCenter;
        cell.someoneLabel.textColor = kRankHeadTitleTextColor;
        cell.someoneLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [cell.contentView addSubview:cell.someoneLabel];
        
        cell.dateLabel = [[UILabel alloc] init];
        cell.dateLabel.text = @"2015-09-25 12:12:09";
        cell.dateLabel.font = [UIFont systemFontOfSize:15.0];
        cell.dateLabel.textAlignment = NSTextAlignmentCenter;
        cell.dateLabel.textColor = kRankHeadTitleTextColor;
        cell.dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [cell.contentView addSubview:cell.dateLabel];
        
        cell.remarkLabel = [[UILabel alloc] init];
        cell.remarkLabel.translatesAutoresizingMaskIntoConstraints = NO;
        cell.remarkLabel.text = @"评语:该店进步非常大，值得大家一起学习！";
        cell.remarkLabel.font = [UIFont systemFontOfSize:15.0];
        cell.remarkLabel.textColor = kRankHeadTitleTextColor;
        [cell.contentView addSubview:cell.remarkLabel];
        
        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneCenterX = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:5];
        [cell.contentView addConstraint:someoneCenterX];
        
        NSLayoutConstraint *someoneWidth = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:100];
        [cell.contentView addConstraint:someoneWidth];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:someoneHeight];
        
        //
        NSLayoutConstraint *dateTop = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:dateTop];
        
        NSLayoutConstraint *dateLeft = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [cell.contentView addConstraint:dateLeft];
        
        NSLayoutConstraint *dateRight = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:cell.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [cell.contentView addConstraint:dateRight];
        
        NSLayoutConstraint *dateHeight = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:dateHeight];
        
        //
        NSLayoutConstraint *remarkTop = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:remarkTop];
        
        NSLayoutConstraint *remarkLeft = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [cell.contentView addConstraint:remarkLeft];
        
        NSLayoutConstraint *remarkRight = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:cell.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [cell.contentView addConstraint:remarkRight];
        
        NSLayoutConstraint *remarkHeight = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:remarkHeight];
        
    } else {
        
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
        
        if (cell.someoneLabel) {
            [cell.someoneLabel removeFromSuperview];
            cell.someoneLabel = nil;
        }
        
        if (cell.dateLabel) {
            [cell.dateLabel removeFromSuperview];
            cell.dateLabel = nil;
        }
        
        if (cell.remarkLabel) {
            [cell.remarkLabel removeFromSuperview];
            cell.remarkLabel = nil;
        }
    }
    
    [_tableView beginUpdates];
    [_tableView endUpdates];
}

#pragma mark - UITableView DataSource/Delegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 7;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RankingListCell *cell=[tableView dequeueReusableCellWithIdentifier:kRankingCell];
    if (!cell) {
        cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankingCell];
    }
    // 前三个店名次显示图片
    if (indexPath.row < 3) {
        cell.scoreState = ScoreStateHigh;
        NSString *imageName = [NSString stringWithFormat:@"medal_0%ld", (long)(indexPath.row + 1)];
        cell.gradeImageView.image = [UIImage imageNamed:imageName];
    } else {
        cell.scoreState = ScoreStateLow;
        NSString *rankStr = [NSString stringWithFormat:@"第 %ld 名", (long)(indexPath.row + 1)];
        NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
        [cell.gradeLabel setAttributedText:rankAttr];

    }
    [cell.shopNameButton setTitle:@"上海真北店" forState:UIControlStateNormal];
    cell.scoreLabel.text = @"98";
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    // 添加点击事件
    [cell.shopNameButton addTarget:self action:@selector(loadMoreInfo:) forControlEvents:UIControlEventTouchUpInside];
    
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
    rankDetailVC.indexRow = indexPath.row;
    [self.navigationController pushViewController:rankDetailVC animated:YES];
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if([self cellIsSelected:indexPath]) {
        return 108;
    }
    
    return 50;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 40;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.backgroundColor = kSectionBackGroundColor;
    
    // 商场
    UILabel *shoppingLabel = [[UILabel alloc] init];
    shoppingLabel.text = @"商场名称";
    shoppingLabel.textAlignment = NSTextAlignmentCenter;
    shoppingLabel.textColor = kRankHeadTitleTextColor;
    shoppingLabel.font = [UIFont systemFontOfSize:17.0];
    shoppingLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:shoppingLabel];
    
    // 总分
    UILabel *scoreLabel = [[UILabel alloc] init];
    scoreLabel.text = @"总分";
    scoreLabel.textAlignment = NSTextAlignmentCenter;
    scoreLabel.textColor = kRankHeadTitleTextColor;
    scoreLabel.font = [UIFont systemFontOfSize:17.0];
    scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:scoreLabel];

    // 排名
    UILabel *gradeLabel = [[UILabel alloc] init];
    gradeLabel.text = @"排名";
    gradeLabel.textAlignment = NSTextAlignmentCenter;
    gradeLabel.textColor = kRankHeadTitleTextColor;
    gradeLabel.font = [UIFont systemFontOfSize:17.0];
    gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:gradeLabel];

    //
    NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [sectionView addConstraint:shoppingTop];
    
    NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:shoppingLeft];
    
    NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:shoppingRight];
    
    NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:shoppingBottom];
    
    NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:scoreLabel attribute:NSLayoutAttributeWidth multiplier:1.2 constant:0];
    [sectionView addConstraint:shoppingWidth];
    
    //
    NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [sectionView addConstraint:scoreTop];
    
    NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:gradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:scoreRight];
    
    NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:gradeLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [sectionView addConstraint:scoreWidth];
    
    NSLayoutConstraint *scoreBottom = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:scoreBottom];
    
    //
    NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [sectionView addConstraint:gradeTop];
    
    NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:gradeRight];
    
    NSLayoutConstraint *gradeBottom = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:gradeBottom];
    
    return sectionView;
}


#pragma mark - lazy loading
- (UILabel *)pointLabel1
{
    if (!_pointLabel1) {
        _pointLabel1 = [[UILabel alloc] init];
        _pointLabel1.translatesAutoresizingMaskIntoConstraints = NO;
        _pointLabel1.textColor = kRankHeadTitleTextColor;
        _pointLabel1.font = [UIFont systemFontOfSize:15.0];
        _pointLabel1.textAlignment = NSTextAlignmentCenter;
        [self.headView addSubview:_pointLabel1];
        
        NSLayoutConstraint *point1Top = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7];
        [self.headView addConstraint:point1Top];
        
        NSLayoutConstraint *point1Right = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.lineView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:point1Right];
        
        NSLayoutConstraint *point1Left = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:point1Left];
        
        NSLayoutConstraint *point1Height = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.headView addConstraint:point1Height];
    }
    return _pointLabel1;
}

- (UILabel *)pointLabel2
{
    if (!_pointLabel2) {
        _pointLabel2 = [[UILabel alloc] init];
        _pointLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _pointLabel2.textColor = kRankHeadTitleTextColor;
        _pointLabel2.font = [UIFont systemFontOfSize:15.0];
        _pointLabel2.textAlignment = NSTextAlignmentCenter;
        [self.headView addSubview:_pointLabel2];
        
        NSLayoutConstraint *point2Top = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7];
        [self.headView addConstraint:point2Top];
        
        NSLayoutConstraint *point2Right = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:point2Right];
        
        NSLayoutConstraint *point2Left = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:16];
        [self.headView addConstraint:point2Left];
        
        NSLayoutConstraint *point2Height = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [_pointLabel2 addConstraint:point2Height];
    }
    return _pointLabel2;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UILabel alloc] init];
        _lineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_lineView];
        
        
        NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.headView addConstraint:lineTop];
        
        NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:15];
        [self.headView addConstraint:lineLeft];
        
        NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
        [_lineView addConstraint:lineWidth];
        
        NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [_lineView addConstraint:lineHeight];

    }
    return _lineView;
}

- (DateButton *)dateButton
{
    if (!_dateButton) {
        _dateButton = [[DateButton alloc] init];
        _dateButton.translatesAutoresizingMaskIntoConstraints = NO;
        
        NSString *dateStr = [NSString stringWithFormat:@"2015 年 08 月"];
        NSMutableAttributedString *dateAttr = [[NSMutableAttributedString alloc] initWithString:dateStr];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:kDateButtonTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(0,5)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(5,1)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:kDateButtonTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(6,4)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(10,1)];
        [_dateButton setAttributedTitle:dateAttr forState:UIControlStateNormal];
        
        [self.headView addSubview:_dateButton];
        
        NSLayoutConstraint *dateTop = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pointLabel1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:dateTop];
        
        NSLayoutConstraint *dateLeft = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pointLabel1 attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-70];
        [self.headView addConstraint:dateLeft];
        
        NSLayoutConstraint *dateWidth = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:150];
        [self.headView addConstraint:dateWidth];
        
        NSLayoutConstraint *dateHeight = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [_dateButton addConstraint:dateHeight];
    }
    return _dateButton;
}

- (UILabel *)shoppingCountLabel
{
    if (!_shoppingCountLabel) {
        _shoppingCountLabel = [[UILabel alloc] init];
        _shoppingCountLabel.translatesAutoresizingMaskIntoConstraints = NO;
        NSString *shopCount = [NSString stringWithFormat:@"21 家"];
        NSMutableAttributedString *shopAttr = [[NSMutableAttributedString alloc] initWithString:shopCount];
        [shopAttr addAttributes:@{NSForegroundColorAttributeName:kShopCountTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(0,shopCount.length - 2)];
        [shopAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(shopCount.length - 2,2)];
        _shoppingCountLabel.attributedText = shopAttr;
        
        [self.headView addSubview:_shoppingCountLabel];
        
        NSLayoutConstraint *shoppingCountTop = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pointLabel2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingCountTop];
        
        NSLayoutConstraint *shoppingCountLeft = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.lineView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingCountLeft];
        
        NSLayoutConstraint *shoppingCountRight = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingCountRight];
        
        NSLayoutConstraint *shoppingCountHeight = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [_shoppingCountLabel addConstraint:shoppingCountHeight];
    }
    return _shoppingCountLabel;
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (UIView *)lineView1
{
    if (!_lineView1) {
        _lineView1 = [[UIView alloc] init];
        _lineView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_lineView1];
        
        NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:lineBottom];
        
        NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:lineLeft];
        
        NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:lineRight];
        
        NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:2];
        [_lineView1 addConstraint:lineHeight];
    }
    return _lineView1;
}

- (UIView *)headView
{
    if (!_headView) {
        _headView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 76)];
        _headView.backgroundColor = [UIColor whiteColor];
    }
    return _headView;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
