//
//  RankDetailViewController.m
//  redstar
//
//  Created by admin on 15/10/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankDetailViewController.h"
#import "RankShopDetialCell.h"
#import "RankWorkDetailCell.h"

#define kRankDetailFirstCell @"RankShopDetialCell"
#define kRankDetailSecondCell @"RankWorkDetailCell"

@interface RankDetailViewController () <UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSArray *test1Array;
@property (nonatomic, strong) NSArray *test2Array;
@property (nonatomic, strong) NSArray *test3Array;

@end

@implementation RankDetailViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor lightGrayColor];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑详情"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    // 添加tableView
    [self addTableView];
    
    self.test1Array = [NSArray arrayWithObjects:@"全员服务",@"15分钟退单",@"送货跟单",@"企划环境升级",@"物业环境改造", nil];
    self.test2Array = [NSArray arrayWithObjects:@(100),@(100),@(99),@(100),@(98), nil];
    self.test3Array = [NSArray arrayWithObjects:@(1),@(1),@(2),@(1),@(3), nil];

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)addTableView {
    // 注册cell
    [self.tableView registerClass:[RankShopDetialCell class] forCellReuseIdentifier:kRankDetailFirstCell];
    [self.tableView registerClass:[RankWorkDetailCell class] forCellReuseIdentifier:kRankDetailSecondCell];
}

#pragma mark - UITableView DataSource/Delegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else {
        return 5;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        RankShopDetialCell *cell=[tableView dequeueReusableCellWithIdentifier:kRankDetailFirstCell];
        if (!cell) {
            cell = [[RankShopDetialCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankDetailFirstCell];
        }
        cell.addressLabel.text = @"上海市真北路1108号";
        cell.titleLabel.text = @"2015年8月口碑巡检";
        cell.reportTimeLabel.text = @"上报时间";
        cell.totalScoreLabel.text = @"总评分";
        cell.totalGradeLabel.text = @"总排名";
        cell.timeLabel.text = @"2015-08-15";
        cell.scoreLabel.text = @"100";
        if (self.indexRow < 3) {
            NSString *imageName = [NSString stringWithFormat:@"medal_0%ld", (long)(_indexRow + 1)];
            cell.gradeImageView.image = [UIImage imageNamed:imageName];
        } else {
            NSString *rankStr = [NSString stringWithFormat:@"第 %ld 名", (long)(_indexRow + 1)];
            NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
            [cell.gradeLabel setAttributedText:rankAttr];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;

    } else {
        RankWorkDetailCell *cell=[tableView dequeueReusableCellWithIdentifier:kRankDetailSecondCell];
        if (!cell) {
            cell = [[RankWorkDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankDetailSecondCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.workNameLabel.text = _test1Array[indexPath.row];
        NSString *scoreStr = [NSString stringWithFormat:@"%@ 分", _test2Array[indexPath.row]];
        NSMutableAttributedString *scoreAttr = [[NSMutableAttributedString alloc] initWithString:scoreStr];
        [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kNavigationBarColor,NSFontAttributeName:[UIFont systemFontOfSize:19.0f]} range:NSMakeRange(0,scoreAttr.length - 1)];
        [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kDetailSmallTitleColor, NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(scoreAttr.length - 1,1)];
        [cell.scoreLabel setAttributedText:scoreAttr];
        
        NSString *rankStr = [NSString stringWithFormat:@"第 %@ 名", _test3Array[indexPath.row]];
        NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
        [cell.gradeLabel setAttributedText:rankAttr];
        return cell;
    }

}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        return 208;
    }
    return 50;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

// foot高度
- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.backgroundColor = kMineBackGroundColor;
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:titleLabel];
    
    UIButton *clickButton= [[UIButton alloc] init];
    clickButton.translatesAutoresizingMaskIntoConstraints = NO;
    clickButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [sectionView addSubview:clickButton];
    
    UIImageView *arrowImageView = [[UIImageView alloc] init];
    arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
    arrowImageView.image = [UIImage imageNamed:@"arrow_right"];
    [sectionView addSubview:arrowImageView];
    
    if (section == 0) {
        titleLabel.text = @"上海真北店";
        titleLabel.textColor = kDetailSection0TitleColor;
        titleLabel.font = [UIFont systemFontOfSize:18.0];
        [clickButton setTitleColor:kDetailSection1TitleColor forState:UIControlStateNormal];
        [clickButton setTitle:@"历史成绩" forState:UIControlStateNormal];
    } else {
        titleLabel.text = @"口碑七大重点工作详情";
        titleLabel.textColor = kDetailSection1TitleColor;
        titleLabel.font = [UIFont systemFontOfSize:17.0];
        [clickButton setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [clickButton setTitle:@"展开全部" forState:UIControlStateNormal];
    }
    
    // label
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:titleTop];
    
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLeft];
    
    NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:170];
    [sectionView addConstraint:titleWidth];
    
    NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleBottom];
    
    // button
    NSLayoutConstraint *clickTop = [NSLayoutConstraint constraintWithItem:clickButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:clickTop];
    
    NSLayoutConstraint *clickRight = [NSLayoutConstraint constraintWithItem:clickButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-3];
    [sectionView addConstraint:clickRight];
    
    NSLayoutConstraint *clickWidth = [NSLayoutConstraint constraintWithItem:clickButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
    [sectionView addConstraint:clickWidth];
    
    NSLayoutConstraint *clickBottom = [NSLayoutConstraint constraintWithItem:clickButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:clickBottom];
    
    // button
    NSLayoutConstraint *arrowTop = [NSLayoutConstraint constraintWithItem:arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:16];
    [sectionView addConstraint:arrowTop];
    
    NSLayoutConstraint *arrowRight = [NSLayoutConstraint constraintWithItem:arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:arrowRight];
    
    NSLayoutConstraint *arrowWidth = [NSLayoutConstraint constraintWithItem:arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
    [sectionView addConstraint:arrowWidth];
    
    NSLayoutConstraint *arrowBottom = [NSLayoutConstraint constraintWithItem:arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:13];
    [sectionView addConstraint:arrowBottom];
    return sectionView;
}

#pragma mark - lazy Laoding
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
