//
//  RankWorkDetailCell.m
//  redstar
//
//  Created by admin on 15/10/31.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankWorkDetailCell.h"

@implementation RankWorkDetailCell

- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.workNameLabel.font = [UIFont systemFontOfSize:18.0];
    self.arrowImageView.backgroundColor = [UIColor clearColor];
}

#pragma mark - lazy laoding
- (UILabel *)workNameLabel
{
    if (!_workNameLabel) {
        _workNameLabel = [[UILabel alloc] init];
        _workNameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _workNameLabel.textColor = kDetailBigTitleColor;
        [self.contentView addSubview:_workNameLabel];
        
        NSLayoutConstraint *workNameTop = [NSLayoutConstraint constraintWithItem:_workNameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:workNameTop];
        
        NSLayoutConstraint *workNameLeft = [NSLayoutConstraint constraintWithItem:_workNameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:workNameLeft];
        
        NSLayoutConstraint *workNameBottom = [NSLayoutConstraint constraintWithItem:_workNameLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:workNameBottom];
        
        NSLayoutConstraint *workNameRight = [NSLayoutConstraint constraintWithItem:_workNameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-5];
        [self.contentView addConstraint:workNameRight];

    }
    return _workNameLabel;
}

- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _scoreLabel.textAlignment = NSTextAlignmentRight;
        [self.contentView addSubview:_scoreLabel];
        
        NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:scoreTop];
        
        NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:scoreWidth];
        
        NSLayoutConstraint *scoreBottom = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:scoreBottom];
        
        NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.contentView addConstraint:scoreRight];
        
    }
    return _scoreLabel;
}

- (UILabel *)gradeLabel
{
    if (!_gradeLabel) {
        _gradeLabel = [[UILabel alloc] init];
        _gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _gradeLabel.textAlignment = NSTextAlignmentRight;
        [self.contentView addSubview:_gradeLabel];
        
        NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:gradeTop];
        
        NSLayoutConstraint *gradeWidth = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:gradeWidth];
        
        NSLayoutConstraint *gradeBottom = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:gradeBottom];
        
        NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-5];
        [self.contentView addConstraint:gradeRight];
        
    }
    return _gradeLabel;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_arrowImageView];
        
        NSLayoutConstraint *arrowTop = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:18];
        [self.contentView addConstraint:arrowTop];
        
        NSLayoutConstraint *arrowRight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:arrowRight];
        
        NSLayoutConstraint *arrowHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:14];
        [self.contentView addConstraint:arrowHeight];
        
        NSLayoutConstraint *arrowWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:14];
        [self.contentView addConstraint:arrowWidth];
        
        
        
    }
    return _arrowImageView;
}

@end
