//
//  InspectTaskSortCell.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectTaskSortCell.h"

@implementation InspectTaskSortCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark Private Methods
- (void)setup {
    self.arrowImageView.backgroundColor = [UIColor orangeColor];
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont systemFontOfSize:17.0];
        _titleLabel.textColor = kLightBlack;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.alreadyLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateBottom];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:85];
        [self.contentView addConstraint:overDateWidth];
    }
    return _titleLabel;
}

- (UILabel *)alreadyLabel
{
    if (!_alreadyLabel) {
        _alreadyLabel = [[UILabel alloc] init];
        _alreadyLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _alreadyLabel.font = [UIFont systemFontOfSize:17.0];
        _alreadyLabel.textColor = kLightBlack;
        _alreadyLabel.textAlignment = NSTextAlignmentRight;
        [self.contentView addSubview:_alreadyLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self.contentView addConstraint:overDateWidth];

        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateBottom];
    }
    return _alreadyLabel;
}

- (UILabel *)allLabel
{
    if (!_allLabel) {
        _allLabel = [[UILabel alloc] init];
        _allLabel.translatesAutoresizingMaskIntoConstraints = NO;

        _allLabel.font = [UIFont systemFontOfSize:17.0];
        _allLabel.textColor = kLightBlack;
        [self.contentView addSubview:_allLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self.contentView addConstraint:overDateWidth];
//
                
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateBottom];
    }
    return _allLabel;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
       
        [self.contentView addSubview:_arrowImageView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:17];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:15];
        [self.contentView addConstraint:overDateWidth];
        //
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateheight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:15];
        [self.contentView addConstraint:overDateheight];
    }
    return _arrowImageView;

}
@end
