//
//  InspectTaskDetailCell.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectTaskDetailCell.h"

@interface InspectTaskDetailCell()
@property (nonatomic, strong) UILabel *shopname; // 商店名称
@property (nonatomic, strong) UILabel *startDate; // 起始时间
@property (nonatomic, strong) UILabel *overDate; // 截止时间
@property (nonatomic, strong) UILabel *progress; // 完成进度
@property (nonatomic, strong) UIView *alreadyView;
@property (nonatomic, strong) UIView *allView;
@property (nonatomic, strong) UILabel *introLabel;

@property (nonatomic, strong) UILabel *surplus; // 剩余
@property (nonatomic, strong) UILabel *day; // 天
@property (nonatomic, strong) UIImageView *number; // 天


@end

@implementation InspectTaskDetailCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark Private Methods
- (void)setup {
    self.shopname.text = @"商场名称";
    self.startDate.text = @"起始时间";
    self.overDate.text = @"截止时间";
    self.progress.text = @"完成进度";
    
    self.introLabel.text = @"巡检说明";
    
    self.day.text = @"天";
    self.number.image = [UIImage imageNamed:@"figure_bg"];
    self.surplus.text = @"剩余";
    self.unfoldBtn.titleLabel.font = [UIFont systemFontOfSize:12.0];
    self.arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_down"];
}

- (void)setProgressState:(ProgressState)progressState
{
    _progressState = progressState;
    if (_progressState == ProgressStateUnSettled) {
        self.progressLabel.text = [NSString stringWithFormat:@"未处理 %f", _multiplier];;
        self.progressLabel.textColor = kProgressUnSettledColor;
        self.alreadyLabel.textColor = kProgressUnSettledColor;
        self.allLabel.textColor = kProgressUnSettledColor;
        self.allView.backgroundColor = kProgressViewAllBackColor;
        self.alreadyView.backgroundColor = kProgressViewAlreadyBackColor;
        
    } else if (_progressState == ProgressStateDealWith) {
        
        self.progressLabel.text = [NSString stringWithFormat:@"进行中 %f", _multiplier];
        self.progressLabel.textColor = kProgressDealWithColor;
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
        self.allView.backgroundColor = kProgressViewAllBackColor;
        self.alreadyView.backgroundColor = kProgressViewAlreadyBackColor;
        
    } else {
        
        self.progressLabel.text = [NSString stringWithFormat:@"已过期 %f", _multiplier];
        self.progressLabel.textColor = kProgressOverDueColor;
        self.alreadyLabel.textColor = kProgressOverDueColor;
        self.allLabel.textColor = kProgressOverDueColor;
        self.allView.backgroundColor = kProgressViewAllBackColor;
        self.alreadyView.backgroundColor = kProgressViewAlreadyBackColor;
    }
}

#pragma mark - lazy loading
- (UILabel *)shopname
{
    if (!_shopname) {
        _shopname = [[UILabel alloc] init];
        _shopname.font = [UIFont systemFontOfSize:15.0];
        _shopname.textColor = kLightGray;
        _shopname.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_shopname];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _shopname;
}


- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.font = [UIFont systemFontOfSize:15.0];
        _startDate.textColor = kLightGray;
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_startDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopname attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _startDate;
}

- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:15.0];
        _overDate.textColor = kLightGray;
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_overDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _overDate;
}

- (UILabel *)progress
{
    if (!_progress) {
        _progress = [[UILabel alloc] init];
        _progress.font = [UIFont systemFontOfSize:15.0];
        _progress.textColor = kLightGray;
        _progress.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_progress];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_progress attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_progress attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_progress attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_progress attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _progress;
}

- (UIView *)allView
{
    if (!_allView) {
        _allView = [[UILabel alloc] init];
        _allView.translatesAutoresizingMaskIntoConstraints = NO;
        _allView.layer.cornerRadius = 3;
        _allView.layer.masksToBounds = YES;
        _allView.layer.borderWidth = 1;
        _allView.layer.borderColor = kUsernameBorderColor;
        [self.contentView addSubview:_allView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.progress attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:18];
        [self.contentView addConstraint:Height];
    }
    return _allView;
}

- (UIView *)alreadyView
{
    if (!_alreadyView) {
        _alreadyView = [[UIView alloc] init];
        _alreadyView.layer.cornerRadius = 3;
        _alreadyView.layer.masksToBounds = YES;
        _alreadyView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.allView addSubview:_alreadyView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.allView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.allView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.allView addConstraint:overDateBottom];
        
        NSLayoutConstraint *overDatewidth = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeWidth multiplier:self.multiplier constant:-1];
        [self.allView addConstraint:overDatewidth];
        
    }
    return _alreadyView;
}

- (UILabel *)introLabel
{
    if (!_introLabel) {
        _introLabel = [[UILabel alloc] init];
        _introLabel.font = [UIFont systemFontOfSize:15.0];
        _introLabel.textColor = kLightGray;
        _introLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_introLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _introLabel;
}

- (UILabel *)shopnameLabel
{
    if (!_shopnameLabel) {
        _shopnameLabel = [[UILabel alloc] init];
        _shopnameLabel.font = [UIFont systemFontOfSize:15.0];
        _shopnameLabel.textColor = kLightBlack;
        _shopnameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_shopnameLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.shopname attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _shopnameLabel;
}


- (UILabel *)day
{
    if (!_day) {
        _day = [[UILabel alloc] init];
        _day.font = [UIFont systemFontOfSize:15.0];
        _day.textColor = kLightBlack;
        _day.textAlignment = NSTextAlignmentCenter;
        _day.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_day];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _day;
}


- (UIImageView *)number
{
    if (!_number) {
        _number = [[UIImageView alloc] init];
        _number.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_number];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.day attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:26];
        [self.contentView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _number;
}

- (UILabel *)surplus
{
    if (!_surplus) {
        _surplus = [[UILabel alloc] init];
        _surplus.font = [UIFont systemFontOfSize:15.0];
        _surplus.textColor = kLightBlack;
        _surplus.textAlignment = NSTextAlignmentCenter;
        _surplus.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_surplus];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.contentView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _surplus;
}


- (UILabel *)startDateLabel
{
    if (!_startDateLabel) {
        _startDateLabel = [[UILabel alloc] init];
        _startDateLabel.font = [UIFont systemFontOfSize:15.0];
        _startDateLabel.textColor = kLightBlack;
        _startDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_startDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.surplus attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _startDateLabel;
}


- (UILabel *)overDateLabel
{
    if (!_overDateLabel) {
        _overDateLabel = [[UILabel alloc] init];
        _overDateLabel.font = [UIFont systemFontOfSize:15.0];
        _overDateLabel.textColor = kLightBlack;
        _overDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_overDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _overDateLabel;
}

- (UILabel *)progressLabel
{
    if (!_progressLabel) {
        _progressLabel = [[UILabel alloc] init];
        _progressLabel.font = [UIFont systemFontOfSize:15.0];
        _progressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_progressLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.progress attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.alreadyLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _progressLabel;
}

- (UILabel *)alreadyLabel
{
    if (!_alreadyLabel) {
        _alreadyLabel = [[UILabel alloc] init];
        _alreadyLabel.textAlignment = NSTextAlignmentRight;
        _alreadyLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_alreadyLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:overDateHeight];
    }
    return _alreadyLabel;
}

- (UILabel *)allLabel
{
    if (!_allLabel) {
        _allLabel = [[UILabel alloc] init];
        _allLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_allLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-18];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:overDateHeight];
    }
    return _allLabel;
}

- (UIButton *)unfoldBtn
{
    if (!_unfoldBtn) {
        _unfoldBtn = [[UIButton alloc] init];
        [_unfoldBtn setTitle:@"展开" forState:UIControlStateNormal];
        [_unfoldBtn setTitleColor:kLightGray forState:UIControlStateNormal];
        _unfoldBtn.tag = 2001;
        _unfoldBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_unfoldBtn];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:overDateHeight];
    }
    return _unfoldBtn;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_arrowImageView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:19];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:11];
        [self.contentView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:8];
        [self.contentView addConstraint:Height];
    }
    return _arrowImageView;
}

- (UILabel *)dayLabel
{
    if (!_dayLabel) {
        _dayLabel = [[UILabel alloc] init];
        _dayLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dayLabel.textColor = kProgressUnSettledColor;
        _dayLabel.textAlignment = NSTextAlignmentCenter;
        _dayLabel.font = [UIFont boldSystemFontOfSize:20.0];
        [self.number addSubview:_dayLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.number addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.number addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.number addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.number addConstraint:overDateHeight];
    }
    return _dayLabel;
}



@end
