//
//  InspectListViewController.m
//  redstar
//
//  Created by admin on 15/10/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectListViewController.h"
#import "InspectListCell.h"
#import "MenuButton.h"
#import "InspectTaskViewController.h"

#import "HttpClient.h"

#define kInspectListCell @"InspectListCellTableViewCell"

@interface InspectListViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSArray *test1Array;
@property (nonatomic, strong) NSArray *test2Array;
@property (nonatomic, strong) NSArray *test3Array;
@property (nonatomic, strong) NSArray *test4Array;
@property (nonatomic, strong) NSArray *test5Array;
@property (nonatomic, strong) NSArray *test6Array;

@end

@implementation InspectListViewController
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"巡检列表"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    [self.tableView registerClass:[InspectListCell class] forCellReuseIdentifier:kInspectListCell];
    
    //
    self.test1Array = [NSArray arrayWithObjects:@"2015年9月口碑巡检",@"2015年9月卫生专项巡检",@"2015年9月真北店安全临时巡检",@"2015年10月卫生专项巡检",@"2015年10月设备安全巡检", nil];
    self.test2Array = [NSArray arrayWithObjects:@"2015-09-01 10:28:52",@"2015-09-08 12:47:32",@"2015-10-21 07:58:22",@"2015-10-09 19:08:52",@"2015-09-01 14:19:52", nil];
    self.test3Array = [NSArray arrayWithObjects:@"2015-09-03",@"2015-09-15",@"2015-10-22",@"2015-11-02",@"2015-11-05", nil];
    self.test4Array = [NSArray arrayWithObjects:@"2",@"3",@"1",@"2",@"1", nil];
    self.test5Array = [NSArray arrayWithObjects:@(5),@(12),@(0),@(8),@(20), nil];
    self.test6Array = [NSArray arrayWithObjects:@(16),@(25),@(20),@(100),@(20), nil];
    
    [self requestInspectList];

}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = YES;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private
- (void)taxiBtnCilck:(UIButton *)sender
{
    
}

- (void)requestInspectList
{
//    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
//    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
//    NSDictionary *parameters = @{@"userUuid":@"",
//                                 @"state":@"",
//                                 @"beginDateFrom":,
//                                 @"endDateTo":@"",
//                                 @"nameLike":@"",
//                                 @"queryOrders":@"",
//                                 @"pageNumber":@"",
//                                 @"pageSize":@""};
//    [httpCilent getInspectListWithParameters:parameters completion:^(id response, NSError *error) {
//        
//    }];
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 5;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectListCell];
    if (!cell) {
        cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectListCell];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.titleLabel.text = [NSString stringWithFormat:@"%@", _test1Array[indexPath.row]];
    cell.startDate.text = [NSString stringWithFormat:@"起始时间：%@", _test2Array[indexPath.row]];
    cell.overDate.text = [NSString stringWithFormat:@"截止时间：%@", _test3Array[indexPath.row]];
    if ([_test4Array[indexPath.row] isEqualToString:@"1"]) {
        cell.progressState = ProgressStateUnSettled;
    } else if ([_test4Array[indexPath.row] isEqualToString:@"2"]) {
        cell.progressState = ProgressStateDealWith;
    } else {
        cell.progressState = ProgressStateOverDue;
    }
    cell.alreadyLabel.text = [NSString stringWithFormat:@"%@", _test5Array[indexPath.row]];
    cell.allLabel.text = [NSString stringWithFormat:@"/%@", _test6Array[indexPath.row]];
    CGFloat already = [_test5Array[indexPath.row] floatValue];
    CGFloat all = [_test6Array[indexPath.row] floatValue];
    cell.multiplier = already / all;
    cell.allView.backgroundColor = kProgressViewAllBackColor;
    cell.alreadyView.backgroundColor = kProgressViewAlreadyBackColor;
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectListCell *cell = (InspectListCell *)[self tableView:_tableView cellForRowAtIndexPath:indexPath];
    InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
    inspectTaskVC.multiplier = cell.multiplier;
    inspectTaskVC.alreadyNumber = cell.alreadyLabel.text;
    inspectTaskVC.allNumber = cell.allLabel.text;
    inspectTaskVC.progressState = cell.progressState;
    [self.navigationController pushViewController:inspectTaskVC animated:YES];
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 145;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = kInspectSectionBackGroundColor;
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-0.5];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
    [sectionView addConstraint:lineWidth];
    
    NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:lineBottom];
    
    MenuButton *taxiButton = [[MenuButton alloc] init];
    taxiButton.translatesAutoresizingMaskIntoConstraints = NO;
    [taxiButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [taxiButton setImage:[UIImage imageNamed:@"sort_icon"] forState:UIControlStateNormal];
    taxiButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [taxiButton setTitle:@"排序" forState:UIControlStateNormal];
    [taxiButton addTarget:self action:@selector(taxiBtnCilck:) forControlEvents:UIControlEventTouchUpInside];
    [sectionView addSubview:taxiButton];
    
    MenuButton *screenButton = [[MenuButton alloc] init];
    screenButton.translatesAutoresizingMaskIntoConstraints = NO;
    [screenButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [screenButton setImage:[UIImage imageNamed:@"filter_icon"] forState:UIControlStateNormal];
    screenButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [screenButton setTitle:@"筛选" forState:UIControlStateNormal];
    [sectionView addSubview:screenButton];
    
    // taxiButton布局
    NSLayoutConstraint *taxiButtonTop = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonTop];
    
    NSLayoutConstraint *taxiButtonLeft = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonLeft];
    
    NSLayoutConstraint *taxiButtonWidth = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:screenButton attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonWidth];
    
    NSLayoutConstraint *taxiButtonBottom = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonBottom];
    
    // screenButton布局
    NSLayoutConstraint *screenButtonTop = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonTop];
    
    NSLayoutConstraint *screenButtonRight = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonRight];
    
    NSLayoutConstraint *screenButtonLeft = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:taxiButton attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonLeft];
    
    NSLayoutConstraint *screenButtonBottom = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonBottom];
    
    return sectionView;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

@end
