//
//  InspectListCell.h
//  redstar
//
//  Created by admin on 15/10/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <UIKit/UIKit.h>
typedef enum ProgressState : NSUInteger {
    ProgressStateUnSettled = 0,// 未处理
    ProgressStateDealWith, // 处理中
    ProgressStateOverDue // 已过期
} ProgressState;

@interface InspectListCell : UITableViewCell
@property (nonatomic, strong) UILabel *titleLabel; // 标题
@property (nonatomic, strong) UILabel *startDate; // 起始日期
@property (nonatomic, strong) UILabel *overDate; // 截止日期
@property (nonatomic, assign) ProgressState progressState; // 处理进度

@property (nonatomic, strong) UILabel *alreadyLabel;
@property (nonatomic, strong) UILabel *allLabel;

@property (nonatomic, assign) CGFloat multiplier; // 乘数

@property (nonatomic, strong) UIView *alreadyView;
@property (nonatomic, strong) UIView *allView;
@end
