//
//  InspectSettleViewController.m
//  redstar
//
//  Created by admin on 15/11/4.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectSettleViewController.h"
#import "InspectSettleCell.h"
#import "InspectDetailFooterView.h"

#import "CheckPicViewController.h"

#define kInspectSettleCell @"InspectSettleCell"

@interface InspectSettleViewController () <UITableViewDelegate, UITableViewDataSource, TakePhotoDelegate>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) InspectDetailFooterView *footerView;

@end

@implementation InspectSettleViewController
- (void)viewDidLoad {
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑巡检任务"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    [self.tableView registerClass:[InspectSettleCell class] forCellReuseIdentifier:kInspectSettleCell];
    self.tableView.tableFooterView = self.footerView;
    
    self.footerView.takePhotoView.delegate = self;
    [self.footerView.takePhotoView.btn addTarget:self action:@selector(addNew:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - TakePhoto Delegate
- (void)takePhotoShowPicture:(UIButton *)btn
{
    CheckPicViewController *checkVC = [[CheckPicViewController alloc] init];
    checkVC.checkImage = btn.imageView.image;
    [self.navigationController pushViewController:checkVC animated:YES];
}

#pragma mark - Private Methods
- (void)addNew:(UIButton *)sender
{
    if (![self.footerView.takePhotoView deleClose:sender]) {
        self.footerView.takePhotoView.editTag = -1;

        if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
            UIAlertView* alert = [[UIAlertView alloc] initWithTitle:nil message:@"Unable to find the camera" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
            [alert show];
        } else {
            UIImagePickerController *picker = [[UIImagePickerController alloc] init];
            picker.delegate = self.footerView.takePhotoView;
            picker.sourceType = UIImagePickerControllerSourceTypeCamera;
            picker.modalTransitionStyle=UIModalTransitionStyleFlipHorizontal;
            picker.videoQuality = UIImagePickerControllerQualityTypeLow;
            [self presentViewController:picker animated:YES completion:nil];
        }
    }
}


#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectSettleCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectSettleCell];
    if (!cell) {
        cell = [[InspectSettleCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectSettleCell];
    }
    cell.titleLabel.text = @"3：广场吊旗";
    cell.titleDetailLabel.text = @"要求图片3张";
    cell.introLabel.text = @"参考说明";
    cell.introDetailLabel.text = @"字体以简体中文为主；内容贴近活动主题；悬挂牢固，以不影响顾客浏览体验为佳";
    return cell;
    
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
   
}

//// cell的高度
//- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
//{
//    return 200;
//}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 150.0;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (InspectDetailFooterView *)footerView
{
    if (!_footerView) {
        _footerView = [[InspectDetailFooterView alloc] init];
    }
    return _footerView;
}

@end
