//
//  QuestionViewController.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionViewController.h"
#import "QuestionListTableCell.h"
#import "MenuButton.h"
#import "QuestionDetailViewController.h"
#import "AddQuestionViewController.h"
#import "HttpClient.h"
#import "QuestionModel.h"

#define kQuestionListCell @"questionListTableViewCell"

@interface QuestionViewController () <UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *allQuestionArray;

@end

@implementation QuestionViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    [self requestQuestionList];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)requestQuestionList
{
    // 初始化数组
    self.allQuestionArray = [NSMutableArray array];
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    
    // 请求参数
    NSDictionary *parameters = @{@"user":@"5a74170150b940ae0150b940f8450083",
                                 @"scope":@"all",
                                 @"category":@"",
                                 @"type":@"" ,
                                 @"state":@"resolved"
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block QuestionViewController *weakSelf = self;
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"recods = %@", recordsDict);
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [weakSelf.allQuestionArray addObject:question];
        }
        [weakSelf.tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kQuestionListCell];
    }];
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题与知识"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"新增问题" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
}

- (void)addClick:(UIButton *)sender
{
    AddQuestionViewController *addQuestionVC = [[AddQuestionViewController alloc] init];
    [self.navigationController pushViewController:addQuestionVC animated:YES];
}

- (void)taxiBtnCilck:(UIButton *)sender
{
    
}

#pragma mark - UItableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _allQuestionArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionListTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionListCell];
    if (!cell) {
        cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionListCell];
    }
    cell.question = _allQuestionArray[indexPath.row];
   // cell.stateLabel.text = @"服务 - 15分钟退单";
    return cell;

}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
    questionDetailVC.question = (QuestionModel *)_allQuestionArray[indexPath.row];
    [self.navigationController pushViewController:questionDetailVC animated:YES];
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 120;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = kInspectSectionBackGroundColor;
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-0.5];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
    [sectionView addConstraint:lineWidth];
    
    NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:lineBottom];
    
    MenuButton *taxiButton = [[MenuButton alloc] init];
    taxiButton.translatesAutoresizingMaskIntoConstraints = NO;
    [taxiButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [taxiButton setImage:[UIImage imageNamed:@"sort_icon"] forState:UIControlStateNormal];
    taxiButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [taxiButton setTitle:@"排序" forState:UIControlStateNormal];
    [taxiButton addTarget:self action:@selector(taxiBtnCilck:) forControlEvents:UIControlEventTouchUpInside];
    [sectionView addSubview:taxiButton];
    
    MenuButton *screenButton = [[MenuButton alloc] init];
    screenButton.translatesAutoresizingMaskIntoConstraints = NO;
    [screenButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [screenButton setImage:[UIImage imageNamed:@"filter_icon"] forState:UIControlStateNormal];
    screenButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [screenButton setTitle:@"筛选" forState:UIControlStateNormal];
    [sectionView addSubview:screenButton];
    
    // taxiButton布局
    NSLayoutConstraint *taxiButtonTop = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonTop];
    
    NSLayoutConstraint *taxiButtonLeft = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonLeft];
    
    NSLayoutConstraint *taxiButtonWidth = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:screenButton attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonWidth];
    
    NSLayoutConstraint *taxiButtonBottom = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonBottom];
    
    // screenButton布局
    NSLayoutConstraint *screenButtonTop = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonTop];
    
    NSLayoutConstraint *screenButtonRight = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonRight];
    
    NSLayoutConstraint *screenButtonLeft = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:taxiButton attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonLeft];
    
    NSLayoutConstraint *screenButtonBottom = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonBottom];
    
    return sectionView;
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
