//
//  QuestionDetailViewController.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionDetailViewController.h"
#import "QuestionDetailCell.h"
#import "QuestionCommentCell.h"
#import "QuestionDescribeCell.h"
#import "QuestionDetailFooterView.h"

#import "CommentView.h"

#define kQuestionDetailCell @"QuestionDetailCell" // 问题详情
#define kQuestionCommentCell @"QuestionCommentCell" // 评论
#define kQuestionDescribeCell @"QuestionDescribeCell" // 问题描述
@interface QuestionDetailViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) QuestionDetailFooterView *footerView;
@property (nonatomic, strong) NSArray *test1Array;
@property (nonatomic, strong) NSArray *test2Array;
@property (nonatomic, strong) NSArray *test3Array;

@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) CommentView *commentView;

@end

@implementation QuestionDetailViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.tableView.tableFooterView = self.footerView;
    [self.footerView.addButon addTarget:self action:@selector(addComment:) forControlEvents:UIControlEventTouchUpInside];
    
    [self setupNav];
    
    self.test1Array = [NSArray arrayWithObjects:@"该建议很好", @"有效提高了用户体验，减少不必要的工作，还符合了上级提出的四个现代化，建议多提类似建议!", nil];
    self.test2Array = [NSArray arrayWithObjects:@"李XX 集团XX总", @"王XX 某大区经理", nil];
    self.test3Array = [NSArray arrayWithObjects:@"2015-09-10 10:21:43", @"2015-10-27 11:21:43", nil];

}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = YES;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题详情"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
}

- (void)addComment:(UIButton *)sender
{
    if (!_backGroundView) {
        _backGroundView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeBackGroundView)];
        [_backGroundView addGestureRecognizer:tapGR];
    }
    if (!_commentView) {
        _commentView = [[CommentView alloc] init];
        _commentView.backgroundColor = [UIColor whiteColor];
    }
    [_commentView.quitBtn addTarget:self action:@selector(closeBackGroundView) forControlEvents:UIControlEventTouchUpInside];
    [_commentView.sureBtn addTarget:self action:@selector(submitComment:) forControlEvents:UIControlEventTouchUpInside];
    [self.view insertSubview:_backGroundView aboveSubview:_tableView];
    [self.view insertSubview:_commentView aboveSubview:_backGroundView];
    
    _backGroundView.alpha = 0;
    _backGroundView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
    
    _commentView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = 0.6;
        _commentView.frame = toFrame;
    }];

}

- (void)submitComment:(UIButton *)sender
{
    [self closeBackGroundView];
}

- (void)closeBackGroundView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = .0f;
        _commentView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_backGroundView removeFromSuperview];
        [_commentView removeFromSuperview];
    }];
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else if (section == 1) {
        return 1;
    } else {
        return _test1Array.count;
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
 
    if (indexPath.section == 0) {
        QuestionDetailCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionDetailCell];
        if (!cell) {
            cell = [[QuestionDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionDetailCell];
        }
        cell.question = self.question;
        return cell;

    } else if (indexPath.section == 1) {
        QuestionDescribeCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionDescribeCell];
        if (!cell) {
            cell = [[QuestionDescribeCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionDescribeCell];
        }
        cell.question = self.question;
        return cell;

    } else {
        QuestionCommentCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionCommentCell];
        if (!cell) {
            cell = [[QuestionCommentCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionCommentCell];
        }
        cell.suggestLabel.text = _test1Array[indexPath.row];
        cell.peopleLabel.text = _test2Array[indexPath.row];
        cell.dateLabel.text = _test3Array[indexPath.row];
        return cell;

    }

}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0) {
        return CGFLOAT_MIN;
    } else if (section == 1) {
        return CGFLOAT_MIN;
    } else {
        return 50;
    }
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}



// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    if (section == 2) {
        // 创建sectionView
        UIView *sectionView = [[UIView alloc] init];
        sectionView.userInteractionEnabled = YES;
        sectionView.backgroundColor = kInspectSectionBackGroundColor;
        
        // 创建标题label
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        titleLabel.textColor = kHomeSectionTitleTextColor;
        titleLabel.font = [UIFont systemFontOfSize:16.0];
        titleLabel.text = @"评论";
        [sectionView addSubview:titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [sectionView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [sectionView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:titleLabelBottom];
        
        // 创建标题label
        UIButton *titleBtn = [[UIButton alloc] init];
        titleBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [titleBtn setTitle:@"添加评论" forState:UIControlStateNormal];
        [titleBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        titleBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
        titleBtn.layer.borderColor = kNavigationBarCGColor;
        titleBtn.layer.borderWidth = 1.0;
        titleBtn.layer.cornerRadius = 5;
        titleBtn.backgroundColor = [UIColor whiteColor];
        [sectionView addSubview:titleBtn];
        
        NSLayoutConstraint *titleBtnTop = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [sectionView addConstraint:titleBtnTop];
        
        NSLayoutConstraint *titleBtnRight = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [sectionView addConstraint:titleBtnRight];
        
        NSLayoutConstraint *titleBtnWidth = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleBtnWidth];
        
        NSLayoutConstraint *titleBtnBottom = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [sectionView addConstraint:titleBtnBottom];
    
        
        return sectionView;
    }
    else {
        return nil;
    }
}



#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        [_tableView registerClass:[QuestionDetailCell class] forCellReuseIdentifier:kQuestionDetailCell];
        [_tableView registerClass:[QuestionCommentCell class] forCellReuseIdentifier:kQuestionCommentCell];
        [_tableView registerClass:[QuestionDescribeCell class] forCellReuseIdentifier:kQuestionDescribeCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (QuestionDetailFooterView *)footerView
{
    if (!_footerView) {
        _footerView = [[QuestionDetailFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 140)];
        _footerView.backgroundColor = kSectionBackGroundColor;
    }
    return _footerView;
}


@end
