//
//  AddQuestionViewController.m
//  redstar
//
//  Created by admin on 15/11/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddQuestionViewController.h"
#import "OnLineTableViewCell.h"

#import "AddQuestionFooterView.h"
#import "CheckPicViewController.h"

#define kAddQuestionCell @"addQuestionTableViewCell"

@interface AddQuestionViewController () <UITableViewDelegate, UITableViewDataSource, TakePhotoDelegate>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) AddQuestionFooterView *footerView;

@property (nonatomic, strong) NSArray *titleArray;
@end

@implementation AddQuestionViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"新问题提报"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    self.titleArray = [NSArray arrayWithObjects:@"选择对应专业组", @"选择问题分类", nil];
    
    [self addTableView];
    
    // takePhoto按钮点击事件
    [self.footerView.takePhotoView.btn addTarget:self action:@selector(addNew:) forControlEvents:UIControlEventTouchUpInside];
    self.footerView.takePhotoView.delegate = self;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)addTableView
{
    [self.tableView registerClass:[OnLineTableViewCell class] forCellReuseIdentifier:kAddQuestionCell];
    self.tableView.tableFooterView = self.footerView;
}

- (void)addNew:(UIButton *)sender
{
    if (![self.footerView.takePhotoView deleClose:sender]) {
        self.footerView.takePhotoView.editTag = -1;
        
        if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
            UIAlertView* alert = [[UIAlertView alloc] initWithTitle:nil message:@"Unable to find the camera" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
            [alert show];
        } else {
            UIImagePickerController *picker = [[UIImagePickerController alloc] init];
            picker.delegate = self.footerView.takePhotoView;
            picker.sourceType = UIImagePickerControllerSourceTypeCamera;
            picker.modalTransitionStyle=UIModalTransitionStyleFlipHorizontal;
            picker.videoQuality = UIImagePickerControllerQualityTypeLow;
            [self presentViewController:picker animated:YES completion:nil];
        }
    }
}

#pragma mark - TakePhoto Delegate
- (void)takePhotoShowPicture:(UIButton *)btn
{
    CheckPicViewController *checkVC = [[CheckPicViewController alloc] init];
    checkVC.checkImage = btn.imageView.image;
    [self.navigationController pushViewController:checkVC animated:YES];
}

#pragma mark - TableView Delegate/DateSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    OnLineTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAddQuestionCell];
    if (!cell) {
        cell = [[OnLineTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAddQuestionCell];
    }
    cell.titleLabel.text = [NSString stringWithFormat:@"%@", _titleArray[indexPath.row]];
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return cell;
    
    
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (AddQuestionFooterView *)footerView
{
    if (!_footerView) {
        if (kScreenHeight == 480) {
            _footerView = [[AddQuestionFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 400)];
        } else {
            _footerView = [[AddQuestionFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, (kScreenHeight - 100 - 64))];
        }
    }
    return _footerView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
