//
//  AddQuestionFooterView.m
//  redstar
//
//  Created by admin on 15/11/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddQuestionFooterView.h"

#define kTakePhotoX 0
#define kTakePhotoY 175
#define kTakePhotoWidth (kScreenWidth - kTakePhotoX * 2)
#define kTakePhotoHeight 130 // 待处理

@interface AddQuestionFooterView () <UITextViewDelegate>
@property (nonatomic, strong) UIImageView *backImageView1;
@property (nonatomic, strong) UILabel *placeholderLabel1;
@end

@implementation AddQuestionFooterView
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


- (void)setup
{
    self.backgroundColor = kFootViewBackGroundColor;
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.font = [UIFont systemFontOfSize:16.0];
    titleLabel.text = @"问题与建议描述";
    titleLabel.textColor = kOnLineCellTitleColor;
    [self addSubview:titleLabel];
    
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self addConstraint:titleTop];
    
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:titleLeft];
    
    NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:titleRight];
    
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [self addConstraint:titleHeight];
    
    
    
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    self.backImageView1.image = resizingName;
    
    self.titleTextView.backgroundColor = [UIColor clearColor];
    
    self.placeholderLabel1.text = @"请输入文字...";
    self.takePhotoView.backgroundColor = kSectionBackGroundColor;
    
}

#pragma mark - UITextView Delegate


- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if (![text isEqualToString:@""]) {
            _placeholderLabel1.hidden = YES;
        
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
            _placeholderLabel1.hidden = NO;
        
    }
    
    return YES;
}

#pragma mark - lazy loading
- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:50];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:120];
        [self addConstraint:contentHeight];
    }
    return _backImageView1;
}



- (UITextView *)titleTextView
{
    if (!_titleTextView) {
        _titleTextView = [[UITextView alloc] init];
        _titleTextView.tag = 1001;
        _titleTextView.delegate = self;
        _titleTextView.font = [UIFont systemFontOfSize:15.0];
        _titleTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView1 addSubview:_titleTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentHeight];
    }
    return _titleTextView;
}



- (UILabel *)placeholderLabel1
{
    if (!_placeholderLabel1) {
        _placeholderLabel1 = [[UILabel alloc] init];
        _placeholderLabel1.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel1.textColor = kOnLineCellDetailColor;
        [self.titleTextView addSubview:_placeholderLabel1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.titleTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.titleTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.titleTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.titleTextView addConstraint:contentHeight];
    }
    return _placeholderLabel1;
}

- (TakePhotoView *)takePhotoView
{
    if (!_takePhotoView) {
        _takePhotoView = [[TakePhotoView alloc] initWithFrame:CGRectMake(kTakePhotoX, kTakePhotoY, kTakePhotoWidth, kTakePhotoHeight)];
        [self addSubview:_takePhotoView];
    }
    return _takePhotoView;
}



@end
