//
//  PictureViewController.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureViewController.h"
#import "MenuButton.h"
#import "PictureTableCell.h"

#define kPictureTableViewCell @"pictureTabelViewCell"

@interface PictureViewController () <UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *test1Array;
@property (nonatomic, strong) NSArray *test2Array;
@property (nonatomic, strong) NSArray *test3Array;

@end

@implementation PictureViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setupNav];
    
    [self setupTableView];
    
    // 初始化
    self.test1Array = [NSArray arrayWithObjects:@"【服务口碑现场】第二期",@"讲述红星人自己的故事",@"【服务口碑现场】第一期", nil];
    self.test2Array = [NSArray arrayWithObjects:@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。",@"变成商场服务提升的契机，变成商场服务提升的契机。",@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。", nil];
    self.test3Array = [NSArray arrayWithObjects:@"2015-08-26",@"2015-08-09",@"2015-07-31", nil];
}


#pragma mark - Private Methods

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"图说口碑"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"我要新增" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
}

- (void)setupTableView
{
    [self.tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kPictureTableViewCell];
}

- (void)addClick:(UIButton *)sender
{
    NSLog(@"我要新增");
}


#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _test1Array.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureTableViewCell];
    if (!cell) {
        cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureTableViewCell];
    }
    cell.titleLabel.text = _test1Array[indexPath.row];
    cell.detailsLabel.text = _test2Array[indexPath.row];
    cell.dateLabel.text = [NSString stringWithFormat:@"发布时间: %@", _test3Array[indexPath.row]];
    [cell.thumbBtn setTitle:@"220" forState:UIControlStateNormal];
    [cell.commentBtn setTitle:@"18" forState:UIControlStateNormal];
    return cell;
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 123;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = kInspectSectionBackGroundColor;
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-0.5];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
    [sectionView addConstraint:lineWidth];
    
    NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:lineBottom];
    
    MenuButton *taxiButton = [[MenuButton alloc] init];
    taxiButton.translatesAutoresizingMaskIntoConstraints = NO;
    [taxiButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [taxiButton setImage:[UIImage imageNamed:@"sort_icon"] forState:UIControlStateNormal];
    taxiButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [taxiButton setTitle:@"排序" forState:UIControlStateNormal];
    [sectionView addSubview:taxiButton];
    
    MenuButton *screenButton = [[MenuButton alloc] init];
    screenButton.translatesAutoresizingMaskIntoConstraints = NO;
    [screenButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [screenButton setImage:[UIImage imageNamed:@"filter_icon"] forState:UIControlStateNormal];
    screenButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [screenButton setTitle:@"筛选" forState:UIControlStateNormal];
    [sectionView addSubview:screenButton];
    
    // taxiButton布局
    NSLayoutConstraint *taxiButtonTop = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonTop];
    
    NSLayoutConstraint *taxiButtonLeft = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonLeft];
    
    NSLayoutConstraint *taxiButtonWidth = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:screenButton attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonWidth];
    
    NSLayoutConstraint *taxiButtonBottom = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonBottom];
    
    // screenButton布局
    NSLayoutConstraint *screenButtonTop = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonTop];
    
    NSLayoutConstraint *screenButtonRight = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonRight];
    
    NSLayoutConstraint *screenButtonLeft = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:taxiButton attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonLeft];
    
    NSLayoutConstraint *screenButtonBottom = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonBottom];
    
    return sectionView;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
