//
//  OnLineFooterView.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineFooterView.h"

@interface OnLineFooterView () <UITextViewDelegate>

@property (nonatomic, strong) UIImageView *backImageView1;
@property (nonatomic, strong) UIImageView *backImageView2;
@property (nonatomic, strong) UILabel *placeholderLabel1;
@property (nonatomic, strong) UILabel *placeholderLabel2;

@end

@implementation OnLineFooterView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


- (void)setup
{
    self.backgroundColor = kFootViewBackGroundColor;
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.font = [UIFont systemFontOfSize:16.0];
    titleLabel.text = @"任务标题";
    titleLabel.textColor = kOnLineCellTitleColor;
    [self addSubview:titleLabel];
    
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self addConstraint:titleTop];
    
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:titleLeft];
    
    NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:titleRight];
    
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [self addConstraint:titleHeight];
    
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.translatesAutoresizingMaskIntoConstraints = NO;
    contentLabel.font = [UIFont systemFontOfSize:16.0];
    contentLabel.text = @"任务标题";
    contentLabel.textColor = kOnLineCellTitleColor;
    [self addSubview:contentLabel];
    
    NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:110];
    [self addConstraint:contentTop];
    
    NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:contentLeft];
    
    NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:contentRight];
    
    NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [self addConstraint:contentHeight];
    
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    self.backImageView1.image = resizingName;
    self.backImageView2.image = resizingName;
    
    self.titleTextView.backgroundColor = [UIColor clearColor];
    self.contentTextView.backgroundColor = [UIColor clearColor];
    
    self.placeholderLabel1.text = @"请输入文字...";
    self.placeholderLabel2.text = @"请输入文字...";
    
    [self.saveButton setTitle:@"保存并下达" forState:UIControlStateNormal];

}

#pragma mark - UITextView Delegate


- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if (![text isEqualToString:@""]) {
        if (textView.tag == 1001) {
            _placeholderLabel1.hidden = YES;
        } else {
            _placeholderLabel2.hidden = YES;
        }
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        if (textView.tag == 1001) {
            _placeholderLabel1.hidden = NO;
        } else {
            _placeholderLabel2.hidden = NO;
        }
    }
    
    return YES;
}

#pragma mark - lazy loading
- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:50];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self addConstraint:contentHeight];
    }
    return _backImageView1;
}

- (UIImageView *)backImageView2
{
    if (!_backImageView2) {
        _backImageView2 = [[UIImageView alloc] init];
        _backImageView2.userInteractionEnabled = YES;
        _backImageView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:160];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:120];
        [self addConstraint:contentHeight];
    }
    return _backImageView2;
}

- (UITextView *)titleTextView
{
    if (!_titleTextView) {
        _titleTextView = [[UITextView alloc] init];
        _titleTextView.tag = 1001;
        _titleTextView.delegate = self;
        _titleTextView.font = [UIFont systemFontOfSize:15.0];
        _titleTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView1 addSubview:_titleTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentHeight];
    }
    return _titleTextView;
}

- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.tag = 1002;
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.delegate = self;
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView2 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UILabel *)placeholderLabel1
{
    if (!_placeholderLabel1) {
        _placeholderLabel1 = [[UILabel alloc] init];
        _placeholderLabel1.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel1.textColor = kOnLineCellDetailColor;
        [self.titleTextView addSubview:_placeholderLabel1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.titleTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.titleTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.titleTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.titleTextView addConstraint:contentHeight];
    }
    return _placeholderLabel1;
}

- (UILabel *)placeholderLabel2
{
    if (!_placeholderLabel2) {
        _placeholderLabel2 = [[UILabel alloc] init];
        _placeholderLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel2.textColor = kOnLineCellDetailColor;
        [self.contentTextView addSubview:_placeholderLabel2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.contentTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentTextView addConstraint:contentHeight];
    }
    return _placeholderLabel2;
}

- (UIButton *)saveButton
{
    if (!_saveButton) {
        _saveButton = [[UIButton alloc] init];
        _saveButton.backgroundColor = kNavigationBarColor;
        _saveButton.layer.cornerRadius = 5;
        _saveButton.layer.masksToBounds = YES;
        _saveButton.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_saveButton];
        
        NSLayoutConstraint *saveBottom = [NSLayoutConstraint constraintWithItem:_saveButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-20];
        [self addConstraint:saveBottom];
        
        NSLayoutConstraint *saveLeft = [NSLayoutConstraint constraintWithItem:_saveButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:saveLeft];
        
        NSLayoutConstraint *saveRight = [NSLayoutConstraint constraintWithItem:_saveButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:saveRight];
        
        NSLayoutConstraint *saveHeight = [NSLayoutConstraint constraintWithItem:_saveButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:saveHeight];
    }
    return _saveButton;
}

@end
