//
//  OnLineTableViewCell.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineTableViewCell.h"

@implementation OnLineTableViewCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.textColor = kOnLineCellTitleColor;
    self.selectLabel.textColor = kOnLineCellDetailColor;
}

#pragma mark - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont systemFontOfSize:16.0];

        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.selectLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleBottom];

    }
    return _titleLabel;
}

#pragma mark - lazy loading
- (UILabel *)selectLabel
{
    if (!_selectLabel) {
        _selectLabel = [[UILabel alloc] init];
        _selectLabel.textAlignment = NSTextAlignmentRight;
        _selectLabel.text = @"请选择";
        _selectLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _selectLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_selectLabel];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectTop];
        
        // 左边
        NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectRight];
        
        // 右边
        NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:selectWidth];
        
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectBottom];
    }
    return _selectLabel;
}

@end
