//
//  CommentView.m
//  redstar
//
//  Created by admin on 15/11/5.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "CommentView.h"

#define kStarBarWidth 235

@interface CommentView ()
@property (nonatomic, strong) UILabel *placeholderLabel2;
@property (nonatomic, strong) UIImageView *backImageView2;
@property (nonatomic, strong) UITextView *contentTextView;

@end

@implementation CommentView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.text = @"评分、评论";
    self.starLabel.text = @"星级打分";
    self.commentLabel.text = @"评论内容";
    
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    self.backImageView2.image = resizingName;
    
    self.contentTextView.backgroundColor = [UIColor clearColor];
    
    self.placeholderLabel2.text = @"请输入评论内容...";
    
    [self.sureBtn setTitle:@"确定" forState:UIControlStateNormal];
    
    self.starBar.starNumber = 0;
    
}

#pragma mark - UITextView Delegate


- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    if (![text isEqualToString:@""]) {
        _placeholderLabel2.hidden = YES;
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _placeholderLabel2.hidden = NO;
    }
    
    return YES;
}

#pragma mark - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.userInteractionEnabled = YES;
        _titleLabel.font = [UIFont systemFontOfSize:18.0];
        _titleLabel.textColor = kLightBlack;
        _titleLabel.textAlignment = NSTextAlignmentCenter;
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.backgroundColor = kSectionBackGroundColor;
        [self addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:titleRight];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:titleHeight];
        
    }
    return _titleLabel;
}

- (UIButton *)quitBtn
{
    if (!_quitBtn) {
        _quitBtn = [[UIButton alloc] init];
        _quitBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _quitBtn.backgroundColor = kSectionBackGroundColor;
        [self.titleLabel addSubview:_quitBtn];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_quitBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.titleLabel addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_quitBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.titleLabel addConstraint:titleWidth];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_quitBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.titleLabel addConstraint:titleRight];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_quitBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.titleLabel addConstraint:titleHeight];
        
    }
    return _quitBtn;
}

- (UILabel *)starLabel
{
    if (!_starLabel) {
        _starLabel = [[UILabel alloc] init];
        _starLabel.font = [UIFont systemFontOfSize:16.0];
        _starLabel.textColor = kLightBlack;
        _starLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_starLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_starLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_starLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_starLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self addConstraint:titleWidth];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_starLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self addConstraint:titleHeight];
        
    }
    return _starLabel;
}

- (UILabel *)commentLabel
{
    if (!_commentLabel) {
        _commentLabel = [[UILabel alloc] init];
        _commentLabel.font = [UIFont systemFontOfSize:16.0];
        _commentLabel.textColor = kLightBlack;
        _commentLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_commentLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.starLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:titleRight];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self addConstraint:titleHeight];
        
    }
    return _commentLabel;
}


- (UIImageView *)backImageView2
{
    if (!_backImageView2) {
        _backImageView2 = [[UIImageView alloc] init];
        _backImageView2.userInteractionEnabled = YES;
        _backImageView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.commentLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:125];
        [self addConstraint:contentHeight];
    }
    return _backImageView2;
}


- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.delegate = self;
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView2 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UILabel *)placeholderLabel2
{
    if (!_placeholderLabel2) {
        _placeholderLabel2 = [[UILabel alloc] init];
        _placeholderLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel2.textColor = kOnLineCellDetailColor;
        [self.contentTextView addSubview:_placeholderLabel2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.contentTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentTextView addConstraint:contentHeight];
    }
    return _placeholderLabel2;
}

- (UIButton *)sureBtn
{
    if (!_sureBtn) {
        _sureBtn = [[UIButton alloc] init];
        
        // 设置圆角
        _sureBtn.layer.cornerRadius = 4;
        _sureBtn.layer.masksToBounds = YES;
        _sureBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _sureBtn.backgroundColor = kLoginButtonBackGroundColor;
        [_sureBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _sureBtn.titleLabel.font = [UIFont systemFontOfSize:20.0];
        [self addSubview:_sureBtn];
        
        // 顶端
        NSLayoutConstraint *loginTop = [NSLayoutConstraint constraintWithItem:_sureBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:20];
        [self addConstraint:loginTop];
        
        // 左边
        NSLayoutConstraint *loginLeft = [NSLayoutConstraint constraintWithItem:_sureBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:loginLeft];
        
        // 右边
        NSLayoutConstraint *loginRight = [NSLayoutConstraint constraintWithItem:_sureBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:loginRight];
        
        // 高度
        NSLayoutConstraint *loginHeight = [NSLayoutConstraint constraintWithItem:_sureBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:loginHeight];
    }
    
    return _sureBtn;
}

- (StarBar *)starBar
{
    if (!_starBar) {
        _starBar = [[StarBar alloc] initWithFrame:CGRectMake(kScreenWidth - kStarBarWidth, 55, kStarBarWidth, 30)];
        [self addSubview:_starBar];
        
    }
    return _starBar;
}

@end
