//
//  ChartViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "ChartViewController.h"

@interface ChartViewController ()
@property (nonatomic, strong) UILabel *remindLabel;
@end

@implementation ChartViewController
#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"报表查询"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    self.remindLabel.text = @"暂不开放该功能，待二期研发";
}

#pragma mark - lazy Loading
- (UILabel *)remindLabel
{
    if (!_remindLabel) {
        _remindLabel = [[UILabel alloc] init];
    }
    _remindLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _remindLabel.font = [UIFont systemFontOfSize:40.0];
    _remindLabel.minimumScaleFactor = .5f;
    _remindLabel.textAlignment = NSTextAlignmentCenter;
    _remindLabel.adjustsFontSizeToFitWidth = YES;
    _remindLabel.textColor = kRemindTextColor;
    [self.view addSubview:_remindLabel];
    
    // 顶端
    NSLayoutConstraint *remindTop = [NSLayoutConstraint constraintWithItem:_remindLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:230];
    [self.view addConstraint:remindTop];
    
    // 左边
    NSLayoutConstraint *remindLeft = [NSLayoutConstraint constraintWithItem:_remindLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:30];
    [self.view addConstraint:remindLeft];
    
    // 右边
    NSLayoutConstraint *remindRight = [NSLayoutConstraint constraintWithItem:_remindLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:-30];
    [self.view addConstraint:remindRight];
    
    // 高度
    NSLayoutConstraint *remindHeight = [NSLayoutConstraint constraintWithItem:_remindLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
    [_remindLabel addConstraint:remindHeight];
    
    return _remindLabel;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
@end
