//
//  RootTabBarController.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RootTabBarController.h"

#import "HomeViewController.h"
#import "AnnounceViewController.h"
#import "ChartViewController.h"
#import "MineViewController.h"

@interface RootTabBarController ()
@end

@implementation RootTabBarController

- (void)viewDidLoad
{
    [self setupTabbar];
    
    self.delegate = self;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}

- (void)viewDidDisappear:(BOOL)animated
{
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}

//
- (void)setupTabbar
{
    // 跳转到tabbarController
    
    HomeViewController *home = [[HomeViewController alloc]init];
    UINavigationController *homeNav = [self setUpOneChildViewController:home title:@"首页" imageName:@"home_unchecked" selImageName:@"home_checked"];
    
    
    AnnounceViewController *announce = [[AnnounceViewController alloc] init];
    UINavigationController *announceNav = [self setUpOneChildViewController:announce title:@"公告" imageName:@"notice_unchecked" selImageName:@"notice_checked"];
    
    ChartViewController *chart = [[ChartViewController alloc] init];
    UINavigationController *chartNav = [self setUpOneChildViewController:chart title:@"报表查询" imageName:@"report_unchecked" selImageName:@"report_checked"];
    
    MineViewController *mine = [[MineViewController alloc] init];
    UINavigationController *mineNav = [self setUpOneChildViewController:mine title:@"我的" imageName:@"aboutme_unchecked" selImageName:@"aboutme_checke"];
//    
//    mine.tabBarItem.title= @"我的";
//    mine.tabBarItem.image = [UIImage imageNamed:@"aboutme_unchecked"];
//    mine.tabBarItem.selectedImage = [[UIImage imageNamed:@"aboutme_checke"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
//    mine.tabBarItem.tag = 30001;
//    
   
    
    [[UITabBarItem appearance] setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:
                                                       kNavigationBarColor, NSForegroundColorAttributeName,
                                                       nil] forState:UIControlStateSelected];

    self.viewControllers = @[homeNav, announceNav, chartNav, mineNav];
}



// 添加一个控制器的属性
- (UINavigationController *)setUpOneChildViewController:(UIViewController *)vc title:(NSString *)title imageName:(NSString *)imageName selImageName:(NSString *)selImageName
{
    // 添加TabBar按钮的图片文字
    vc.title = title;
    vc.tabBarItem.image = [UIImage imageNamed:imageName];
    UIImage *selImage = [UIImage imageNamed:selImageName];
    selImage = [selImage imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    vc.tabBarItem.selectedImage = selImage;
    
    // 添加nav
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:vc];
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    return nav;
}

#pragma mark - UITabBarController Delegate
//
//- (BOOL)tabBarController:(UITabBarController *)tabBarController shouldSelectViewController:(UIViewController *)viewController {
//    NSLog(@"shouldSelectViewController  %@", tabBarController.selectedViewController);
//    if (viewController.tabBarItem.tag == 30001) {
//        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:viewController animated:YES];
//        return NO;
//    }
//    return YES;
//}

//- (void)tabBarController:(UITabBarController *)tabBarController didSelectViewController:(UIViewController *)viewController
//{
//    if ([viewController isKindOfClass:[MineViewController class]]) {
//        MineViewController *mine = [[MineViewController alloc] init];
//        mine.tabBarItem.title= @"我的";
//        mine.tabBarItem.image = [UIImage imageNamed:@"aboutme_unchecked"];
//        mine.tabBarItem.selectedImage = [[UIImage imageNamed:@"aboutme_checke"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
//        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:mine animated:YES];
//    }
//}


@end
