//
//  InspectListCell.m
//  redstar
//
//  Created by admin on 15/10/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectListCell.h"
#import "TaskListModel.h"
#import "SpotCheckModel.h"

@interface InspectListCell ()


@end

@implementation InspectListCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.font = [UIFont systemFontOfSize:19.0];
    self.startDate.textColor = kCellDetailColor;
    self.overDate.textColor = kCellDetailColor;
    self.address.textColor = kCellDetailColor;
    self.progressLabel.font = [UIFont systemFontOfSize:14.0];
    self.alreadyLabel.font = [UIFont systemFontOfSize:15.0];
    self.allLabel.font = [UIFont systemFontOfSize:15.0];
    
}

- (void)setSpotCheck:(SpotCheckModel *)spotCheck
{
    _spotCheck = spotCheck;
    self.titleLabel.text = [NSString stringWithFormat:@"%@", spotCheck.title];
    self.startDate.text = [NSString stringWithFormat:@"起始时间：%@", spotCheck.create_time];
    self.overDate.text = [NSString stringWithFormat:@"截止时间：%@", spotCheck.endDate];
    self.address.text = [NSString stringWithFormat:@"巡检商场：%@", @"上海真北店"];
    self.alreadyLabel.text = [NSString stringWithFormat:@"%d", spotCheck.reportCount];
    self.allLabel.text = [NSString stringWithFormat:@"/%d", spotCheck.storeCount];
    
    self.allView.backgroundColor = kProgressViewAllBackColor;
    
    if (spotCheck.reportCount == 0) {
        self.multiplier = 0;
    } else {
        self.multiplier = (CGFloat)spotCheck.reportCount / spotCheck.storeCount;
    }
    
    if (self.multiplier > 1) {
        self.multiplier = 1.0;
    }
    
    UIImage *image = [UIImage imageNamed:@"progress-bar"];
    image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
    self.alreadyView.image = image;
    if ([_spotCheck.state isEqualToString:@"initial"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：未处理"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressUnSettledColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressUnSettledColor;
        self.allLabel.textColor = kProgressUnSettledColor;
    } else if ([_spotCheck.state isEqualToString:@"reported"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：已上报"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
    } else if ([_spotCheck.state isEqualToString:@"finished"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：已评分"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
    } else {
        
    }
}

- (void)setTaskList:(TaskListModel *)taskList
{
    _taskList = taskList;
    self.titleLabel.text = [NSString stringWithFormat:@"%@", taskList.name];
    self.startDate.text = [NSString stringWithFormat:@"起始时间：%@", taskList.beginDate];
    self.overDate.text = [NSString stringWithFormat:@"截止时间：%@", taskList.endDate];
    self.address.text = [NSString stringWithFormat:@"巡检商场：%@", taskList.store_name];
    self.alreadyLabel.text = [NSString stringWithFormat:@"%d", taskList.reportCount];
    self.allLabel.text = [NSString stringWithFormat:@"/%d", taskList.questionCount];

    
    
    self.allView.backgroundColor = kProgressViewAllBackColor;
    
    if (taskList.reportCount == 0) {
        self.multiplier = 0;
    } else {
        self.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount;
    }
    
    if (self.multiplier > 1) {
        self.multiplier = 1.0;
    }
    
    UIImage *image = [UIImage imageNamed:@"progress-bar"];
    image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
    self.alreadyView.image = image;
    if ([taskList.state isEqualToString:@"submitted"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：未处理"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressUnSettledColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressUnSettledColor;
        self.allLabel.textColor = kProgressUnSettledColor;
    } else if ([taskList.state isEqualToString:@"processing"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：进行中"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
    } else if ([taskList.state isEqualToString:@"reported"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：已上报"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
    } else if ([taskList.state isEqualToString:@"finished"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：已评分"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressDealWithColor;
        self.allLabel.textColor = kProgressDealWithColor;
    } else if ([taskList.state isEqualToString:@"published"]) {
        NSString *str = [NSString stringWithFormat:@"巡检进度：已发布"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kNavigationBarColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kNavigationBarColor;
        self.allLabel.textColor = kNavigationBarColor;
    } else if ([taskList.state isEqualToString:@"expired"]){
        NSString *str = [NSString stringWithFormat:@"巡检进度：已过期"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressOverDueColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
        self.alreadyLabel.textColor = kProgressOverDueColor;
        self.allLabel.textColor = kProgressOverDueColor;
    } else {
    }
}

#pragma mark - lazy Loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = kCellTitleColor;
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:8];
        [self.contentView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleLabelRight];
        
        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleLabelHeight];
    }
    return _titleLabel;
}

- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        _startDate.font = [UIFont systemFontOfSize:14.0];
        [self.contentView addSubview:_startDate];
        
        NSLayoutConstraint *startDateTop = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:startDateTop];
        
        NSLayoutConstraint *startDateLeft = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateLeft];
        
        NSLayoutConstraint *startDateRight = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:startDateRight];
        
        NSLayoutConstraint *startDateHeight = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateHeight];
        
    }
    return _startDate;
}

- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:14.0];
        
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_overDate];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _overDate;
}

- (UILabel *)address
{
    if (!_address) {
        _address = [[UILabel alloc] init];
        _address.font = [UIFont systemFontOfSize:14.0];
        
        _address.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_address];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_address attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_address attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_address attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_address attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _address;
}

- (UILabel *)progressLabel
{
    if (!_progressLabel) {
        _progressLabel = [[UILabel alloc] init];
        _progressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_progressLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.address attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.alreadyLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _progressLabel;
}

- (UILabel *)alreadyLabel
{
    if (!_alreadyLabel) {
        _alreadyLabel = [[UILabel alloc] init];
        _alreadyLabel.textAlignment = NSTextAlignmentRight;
        _alreadyLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_alreadyLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.address attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_alreadyLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _alreadyLabel;
}

- (UILabel *)allLabel
{
    if (!_allLabel) {
        _allLabel = [[UILabel alloc] init];
        _allLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_allLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.address attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-18];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_allLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _allLabel;
}



- (UIView *)allView
{
    if (!_allView) {
        _allView = [[UIView alloc] init];
        _allView.translatesAutoresizingMaskIntoConstraints = NO;
        _allView.layer.cornerRadius = 3;
        _allView.layer.borderWidth = 1;
        _allView.layer.masksToBounds = YES;
        _allView.layer.borderColor = kUsernameBorderColor;
        [self.contentView addSubview:_allView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_allView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:overDateBottom];

    }
    return _allView;
}

- (UIImageView *)alreadyView
{
    if (!_alreadyView) {
        _alreadyView = [[UIImageView alloc] init];
        _alreadyView.layer.cornerRadius = 3;
        _alreadyView.layer.masksToBounds = YES;
        _alreadyView.translatesAutoresizingMaskIntoConstraints = NO;
        _alreadyView.tag = 9760001;
        [self.allView addSubview:_alreadyView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.allView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.allView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.allView addConstraint:overDateBottom];
        
        NSLayoutConstraint *overDatewidth = [NSLayoutConstraint constraintWithItem:_alreadyView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.allView attribute:NSLayoutAttributeWidth multiplier:_multiplier constant:-1];
        [self.allView addConstraint:overDatewidth];
        
    }
    return _alreadyView;
}






@end
