//
//  SpotCheckOnLineViewController.m
//  redstar
//
//  Created by admin on 15/11/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SpotCheckOnLineViewController.h"
#import "OnLineViewController.h"
#import "TaxisView.h"
#import "ScreenView.h"
#import "MenuView.h"
#import "OnLineCompleteViewController.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>
#import <MJRefresh.h>
#import "NoDataView.h"

#import "InspectListCell.h"
#import "SpotCheckModel.h"
#define kInspectListTableViewcellIndeterfor @"inspectListTableViewcellIndeterfor"
@interface SpotCheckOnLineViewController ()<UITableViewDelegate, UITableViewDataSource,ScreenTableDelegate, TaxisViewDelegate, InspectTableViewDelegate>
@property (nonatomic, strong) MenuView *menuView;
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) ScreenView *screenView;
@property (nonatomic, strong) MenuButton *selctedButton;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, assign) NSInteger selectRow;
@property (nonatomic, assign) NSInteger timeSelectNum;

@property (nonatomic, strong) NSMutableArray *allSpotCheckList;
@property (nonatomic, strong) NoDataView *noDataView;
@property (nonatomic, assign) int page;


@end

@implementation SpotCheckOnLineViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    self.allSpotCheckList = [NSMutableArray array];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    
    _page = 0;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.tabBarController.tabBar.hidden = YES;
    [self requestSpotCheckList];

}



#pragma mark - Private Mothods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"抽查任务列表"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"新增任务" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addSpotCheckTaskClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)requestSpotCheckList
{
    HttpClient *http = [[HttpClient alloc] initWithUrl:[NSString stringWithFormat:@"%@%@", kRedStarURL, kManageSportcheckURL]];
    // 相关参数
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{@"userUuid":user_uuid,
                                 @"pageNumber":@(0),
                                 @"pageSize":@(10)
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [http getManageSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"管理层的抽查列表 response= %@", response);
        NSLog(@"管理层的抽查列表 error= %@", error);
        NSDictionary *dataDict = response[@"data"];
        NSArray *recordsArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];

        for (NSDictionary *dict in recordsArray) {
            SpotCheckModel *spot = [[SpotCheckModel alloc] init];
            [spot setValuesForKeysWithDictionary:dict];
            [tempArray addObject:spot];
        }
        [_allSpotCheckList addObjectsFromArray:tempArray];
      
        if (_allSpotCheckList.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
            
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            self.tableView.delegate = self;
            self.tableView.dataSource = self;
            // 下拉加载更多
        self.tableView.footer = [MJRefreshBackNormalFooter footerWithRefreshingBlock:^{
            [self requestMoreList];
        }];
            [self.tableView reloadData];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
    }];
}

- (void)requestMoreList
{
    _page++;
    HttpClient *http = [[HttpClient alloc] initWithUrl:[NSString stringWithFormat:@"%@%@", kRedStarURL, kManageSportcheckURL]];
    // 相关参数
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{@"userUuid":user_uuid,
                                 @"pageNumber":@(_page),
                                 @"pageSize":@(10)
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [http getManageSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"上拉加载更多  管理层抽查列表 response= %@", response);
        NSLog(@"上拉加载更多  管理层抽查列表 error= %@", error);
        NSDictionary *dataDict = response[@"data"];
        NSArray *recordsArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in recordsArray) {
            SpotCheckModel *spot = [[SpotCheckModel alloc] init];
            [spot setValuesForKeysWithDictionary:dict];
            [tempArray addObject:spot];
        }
        
        [_allSpotCheckList addObjectsFromArray:tempArray];
        if (tempArray.count < 10) {
            [self.tableView.footer noticeNoMoreData];
        } else {
            [self.tableView.footer endRefreshing];
        }
        [MBProgressHUD hideHUDForView:self.view animated:YES];

        [self.tableView reloadData];
    }];
}


- (void)addSpotCheckTaskClick:(UIButton *)sender
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"当前功能正在开发！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
    [alert show];
//    OnLineViewController *onlineVC = [[OnLineViewController alloc] init];
//    [self.navigationController pushViewController:onlineVC animated:YES];
}

- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            sender.selected = YES;
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            sender.selected = NO;
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}

- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth, kScreenHeight - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.tag = 3928342;
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    _taxisView.alpha = 0.0;
    _taxisView.frame = toFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.alpha = 1.0;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _taxisView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth, kScreenHeight - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[ScreenView alloc] initWithTitleArray:[NSArray arrayWithObjects:@"全部",@"未处理", @"已处理",@"已完成",nil]];
        _screenView.delegate = self;
        _screenView.inspectTableView.inspectDelegate = self;
        _screenView.backgroundColor = [UIColor whiteColor];
    }
    [_screenView.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [_screenView.submitBtn addTarget:self action:@selector(submitClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kScreenViewHeight);
    _screenView.alpha = 0.0;
    _screenView.frame = toFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.alpha = 1.0;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}

// 重置按钮
- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    _screenView.textView.text = @"";
    
    NSInteger timeIndex = 0;
    NSIndexPath *timeIndexPath = [NSIndexPath indexPathForRow:timeIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:timeIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    _selectRow = 0;
}
// 提交按钮
- (void)submitClick:(UIButton *)sender
{
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kManageSportcheckURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSMutableDictionary *parameters = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                       [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],@"userUuid",
                                       @[],@"queryOrders",
                                       @(0),@"pageNumber",
                                       @(10),@"pageSize", nil];
    
    if (_screenView.groupTabBar.selectNumber == 0) {
        
        if (_selectRow == 0) {
            
        } else if (_selectRow == 1) {
            [parameters setObject:@"initial" forKey:@"state"];
        } else if (_selectRow == 2) {
            [parameters setObject:@"reported" forKey:@"state"];
        } else {
            [parameters setObject:@"finished" forKey:@"state"];
        }
        NSArray *array = @[@{@"field":@"state"}];
        [parameters setObject:array forKey:@"queryOrders"];
        _screenView.textView.text = @"";
    } else if (_screenView.groupTabBar.selectNumber == 1) {
        if (_screenView.textView.text.length != 0){
            [parameters setObject:_screenView.textView.text forKey:@"titleLike"];
            NSArray *array = @[@{@"field":@"name"}];
            [parameters setObject:array forKey:@"queryOrders"];
        }
    } else {
        
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
        
        // 当前时间
        NSDate *today = [NSDate date];
        NSString *todayStr = [dateFormatter stringFromDate:today];
        
        if (_timeSelectNum == 0) {
            
            NSDate *week = [today dateByAddingTimeInterval:-60*60*24*7];
            NSString *weekStr = [dateFormatter stringFromDate:week];
            
            [parameters setObject:weekStr forKey:@"endDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else if (_timeSelectNum == 1) {
            
            NSDate *oneMonth = [self getPriousorLaterDateFromDate:today withMonth:-1];
            NSString *oneMonthStr = [dateFormatter stringFromDate:oneMonth];
            
            [parameters setObject:oneMonthStr forKey:@"endDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
            
        } else if (_timeSelectNum == 2) {
            NSDate *threeMonth = [self getPriousorLaterDateFromDate:today withMonth:-3];
            NSString *threeMonthStr = [dateFormatter stringFromDate:threeMonth];
            
            [parameters setObject:threeMonthStr forKey:@"endDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else if (_timeSelectNum == 3) {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            
            [parameters setObject:oneYearStr forKey:@"endDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            [parameters setObject:oneYearStr forKey:@"endDateTo"];
        }
        NSArray *array = @[@{@"field":@"endDate",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    }
    NSLog(@"parrr = %@", parameters);
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [httpCilent getManageSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"管理层的抽查列表 response= %@", response);
        NSLog(@"管理层的抽查列表 error= %@", error);
        
        
        
        if (_allSpotCheckList.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
            
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            self.tableView.delegate = self;
            self.tableView.dataSource = self;
            // 下拉加载更多
            self.tableView.footer = [MJRefreshBackNormalFooter footerWithRefreshingBlock:^{
                [self requestMoreList];
            }];
            [self.tableView reloadData];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
    }];

}

- (NSDate *)getPriousorLaterDateFromDate:(NSDate *)date withMonth:(int)month
{
    NSDateComponents *comps = [[NSDateComponents alloc] init];
    [comps setMonth:month];
    NSCalendar *calender = [[NSCalendar alloc] initWithCalendarIdentifier:NSGregorianCalendar];
    NSDate *mDate = [calender dateByAddingComponents:comps toDate:date options:0];
    return mDate;
}


#pragma mark - InspectTableViewDelegate
- (void)inspectTableViewDidSelectWithRow:(NSInteger)row
{
    _selectRow = row;
}

#pragma mark - TaxisDelegate
- (void)timeChange:(UIButton *)sender
{
    _page = 0;
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kManageSportcheckURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSArray *queryOrders;
    
    if (sender.tag - kTAxisBtnTag == 1) {
        queryOrders = @[];
        
    } else if (sender.tag - kTAxisBtnTag == 2) {
        
        queryOrders = @[@{@"field":@"endDate",
                          @"direction":@"desc"}];
        
    } else {
        queryOrders = @[@{@"field":@"endDate",
                          @"direction":@"asc"}];
    }
    
    
    // 相关参数
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{@"userUuid":user_uuid,
                                 @"pageNumber":@(_page),
                                 @"pageSize":@(10),
                                 @"queryOrders":queryOrders
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [httpCilent getManageSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"管理层的抽查列表 response= %@", response);
        NSLog(@"管理层的抽查列表 error= %@", error);
        NSDictionary *dataDict = response[@"data"];
        NSArray *recordsArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        
        for (NSDictionary *dict in recordsArray) {
            SpotCheckModel *spot = [[SpotCheckModel alloc] init];
            [spot setValuesForKeysWithDictionary:dict];
            [tempArray addObject:spot];
        }
        _allSpotCheckList = tempArray;
        
        if (_allSpotCheckList.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
            
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            self.tableView.delegate = self;
            self.tableView.dataSource = self;
            // 下拉加载更多
            self.tableView.footer = [MJRefreshBackNormalFooter footerWithRefreshingBlock:^{
                [self requestMoreList];
            }];
            [self.tableView reloadData];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
    }];

    [self closeRedView];
}

#pragma mark - ScreenTableDelegate
- (void)tableViewDidSelectRow:(NSInteger)row
{
    _timeSelectNum = row;
}



#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _allSpotCheckList.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectListTableViewcellIndeterfor];
    if (!cell) {
        cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectListTableViewcellIndeterfor];
    }
    cell.spotCheck = _allSpotCheckList[indexPath.row];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    SpotCheckModel *spot = _allSpotCheckList[indexPath.row];
    OnLineCompleteViewController *completeVC = [[OnLineCompleteViewController alloc] init];
    completeVC.uuid = spot.uuid;
    [self.navigationController pushViewController:completeVC animated:YES];
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        [_tableView registerClass:[InspectListCell class] forCellReuseIdentifier:kInspectListTableViewcellIndeterfor];
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (MenuView *)menuView
{
    if (!_menuView) {
        _menuView = [[MenuView alloc] init];
        _menuView.translatesAutoresizingMaskIntoConstraints = NO;
        [_menuView.taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [_menuView.screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:_menuView];
        
        NSLayoutConstraint *menuTop = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:menuTop];
        
        NSLayoutConstraint *menuLeft = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:menuLeft];
        
        NSLayoutConstraint *menuRight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:menuRight];
        
        NSLayoutConstraint *menuHeight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.view addConstraint:menuHeight];
    }
    return _menuView;
}
- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}


@end
