//
//  OnLineViewController.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineViewController.h"
#import "OnLineTableViewCell.h"
#import "OnLineFooterView.h"
#import "SpotCheckOnLineViewController.h"
#import "SelectStoreViewController.h"
#import "HttpClient.h"
#import "TreeNodeModel.h"

#define kOnLineTableViewCell @"onlineTableViewCell"

@interface OnLineViewController () <UITableViewDelegate, UITableViewDataSource, UIAlertViewDelegate, SelectStoreDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *titleArray;
@property (nonatomic, strong) NSMutableArray *uuidArray;
@property (nonatomic, strong) OnLineFooterView *footView;
@property (nonatomic, strong) NSString *storeName;
@end

@implementation OnLineViewController

- (void)viewDidLoad
{
    [super viewDidLoad];

    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"发起抽查任务"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    self.titleArray = [NSArray arrayWithObjects:@"商场名称", @"截止时间", nil];
    
    [self addTableView];
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    _storeName = @"全部";
}

- (void)doBack:(id)sender
{
    if ([[self.navigationController.viewControllers objectAtIndex:0] isKindOfClass:[SpotCheckOnLineViewController class]]) {
        SpotCheckOnLineViewController *spotCheckVC = (SpotCheckOnLineViewController *)[self.navigationController.viewControllers objectAtIndex:0];
        [self.navigationController popToViewController:spotCheckVC animated:YES];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Private Methods
- (void)addTableView
{
    [self.tableView registerClass:[OnLineTableViewCell class] forCellReuseIdentifier:kOnLineTableViewCell];
    self.tableView.tableFooterView = self.footView;
}

- (void)saveClick:(UIButton *)sender
{
    // 提示框
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要下达新的抽查任务吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 334281;
    alert.delegate = self;
    [alert show];
}

#pragma mark - SelectStoreDelegate
- (void)deliverWithArray:(NSMutableArray *)array
{
    NSString *nameStr = @"";
    _uuidArray = [NSMutableArray array];
    for (TreeNodeModel *model in array) {
        nameStr = [nameStr stringByAppendingString:[NSString stringWithFormat:@"%@,", model.name]];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:model.uuid , @"store_uuid", model.code , @"store_code", model.name , @"store_name", nil];
        [_uuidArray addObject:dict];
    }
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    _storeName = nameStr;
    [self.tableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
}

#pragma mark - TableView Delegate/DateSource
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 334281) {
        if (buttonIndex == 1) {
            
            NSDate *date = [NSDate date];
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"YYYY-MM-dd hh:mm:ss"];
            NSString *dateString = [dateFormatter stringFromDate:date];
            
            NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
            NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
            
            
            NSString *url = [NSString stringWithFormat:@"%@%@%@&operId=%@&operName=%@", kRedStarURL, kSaveSportcheckURL, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            NSLog(@"发起抽查url = %@", url);
            HttpClient *httpClient= [[HttpClient alloc] initWithUrl:url];
            
            NSDictionary *parameters = @{
                                         @"title":self.footView.titleTextView.text,
                                         @"content":self.footView.contentTextView.text,
                                         @"endDate":dateString,
                                         @"state":@"initial",
                                         @"stores":_uuidArray
                                         };
            NSLog(@"发起抽查par = %@", parameters);
            [httpClient saveSportCheckWithParameters:parameters completion:^(id response, NSError *error) {
                NSLog(@"发起抽查 response = %@", response);
                NSLog(@"发起抽查 error = %@", error);
                if ([response[@"message"] isEqualToString:@"ok"]) {
                    [self.navigationController popViewControllerAnimated:YES];
                }

            }];
        }
    }
}

#pragma mark - TableView Delegate/DateSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    OnLineTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kOnLineTableViewCell];
    if (!cell) {
        cell = [[OnLineTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kOnLineTableViewCell];
    }
    cell.titleLabel.text = [NSString stringWithFormat:@"%@", _titleArray[indexPath.row]];
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    cell.selectLabel.text = [NSString stringWithFormat:@"%@", _storeName];
    return cell;
    
    
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    SelectStoreViewController *select = [[SelectStoreViewController alloc] init];
    select.delegate = self;
    [self.navigationController pushViewController:select animated:YES];
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (OnLineFooterView *)footView
{
    if (!_footView) {
        if (kScreenHeight == 480) {
            _footView = [[OnLineFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 400)];
        } else {
            _footView = [[OnLineFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, (kScreenHeight - 100 - 64))];
        }
        [_footView.saveButton addTarget:self action:@selector(saveClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _footView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
