//
//  MenuView.m
//  redstar
//
//  Created by admin on 15/11/10.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MenuView.h"

@implementation MenuView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    [self.taxiButton setImage:[UIImage imageNamed:@"sort_icon"] forState:UIControlStateNormal];
    [self.screenButton setImage:[UIImage imageNamed:@"filter_icon"] forState:UIControlStateNormal];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [self addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-0.5];
    [self addConstraint:lineLeft];
    
    NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
    [self addConstraint:lineWidth];
    
    NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:lineBottom];

}

- (MenuButton *)taxiButton
{
    if (!_taxiButton) {
        _taxiButton = [[MenuButton alloc] init];
        _taxiButton.tag = 4001;
        _taxiButton.translatesAutoresizingMaskIntoConstraints = NO;
        [_taxiButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        [_taxiButton setTitleColor:[UIColor orangeColor] forState:UIControlStateSelected];
        [_taxiButton setImage:[UIImage imageNamed:@"sort_icon_after"] forState:UIControlStateSelected];

        _taxiButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
        [_taxiButton setTitle:@"排序" forState:UIControlStateNormal];
        [self addSubview:_taxiButton];
        
        // taxiButton布局
        NSLayoutConstraint *taxiButtonTop = [NSLayoutConstraint constraintWithItem:_taxiButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:taxiButtonTop];
        
        NSLayoutConstraint *taxiButtonLeft = [NSLayoutConstraint constraintWithItem:_taxiButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:taxiButtonLeft];
        
        NSLayoutConstraint *taxiButtonWidth = [NSLayoutConstraint constraintWithItem:_taxiButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.screenButton attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self addConstraint:taxiButtonWidth];
        
        NSLayoutConstraint *taxiButtonBottom = [NSLayoutConstraint constraintWithItem:_taxiButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:taxiButtonBottom];
    }
    return _taxiButton;
}
- (MenuButton *)screenButton
{
    if (!_screenButton) {
        _screenButton = [[MenuButton alloc] init];
        _screenButton.tag = 4002;
        _screenButton.translatesAutoresizingMaskIntoConstraints = NO;
        _screenButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
        [_screenButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        [_screenButton setTitleColor:[UIColor orangeColor] forState:UIControlStateSelected];
        [_screenButton setImage:[UIImage imageNamed:@"filter_after"] forState:UIControlStateSelected];
        [_screenButton setTitle:@"筛选" forState:UIControlStateNormal];
        [self addSubview:_screenButton];
        
        // screenButton布局
        NSLayoutConstraint *screenButtonTop = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:screenButtonTop];
        
        NSLayoutConstraint *screenButtonRight = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:screenButtonRight];
        
        NSLayoutConstraint *screenButtonLeft = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_taxiButton attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:screenButtonLeft];
        
        NSLayoutConstraint *screenButtonBottom = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:screenButtonBottom];
    }
    return _screenButton;
}

@end
