//
//  MineTableHeaderView.m
//  redstar
//
//  Created by admin on 15/10/24.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MineTableHeaderView.h"

@interface MineTableHeaderView()

@end

@implementation MineTableHeaderView

#pragma mark - init
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor grayColor];
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.userLabel.text = @"用户: 陈宁";
    self.numberLabel.text = @"代码: 0005";
    self.companyLabel.text = @"公司: 红星美凯龙家居集团股份有限公司";
}

#pragma mark - lazy loading

- (UILabel *)companyLabel
{
    if (!_companyLabel) {
        _companyLabel = [[UILabel alloc] init];
    }
    _companyLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _companyLabel.minimumScaleFactor = .5f;
    _companyLabel.adjustsFontSizeToFitWidth = YES;
    _companyLabel.textColor = [UIColor whiteColor];
    [self addSubview:_companyLabel];
    
    NSLayoutConstraint *companyHeight = [NSLayoutConstraint constraintWithItem:_companyLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self addConstraint:companyHeight];
    
    NSLayoutConstraint *companyTop = [NSLayoutConstraint constraintWithItem:_companyLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:40];
    [self addConstraint:companyTop];
    
    NSLayoutConstraint *companyRight = [NSLayoutConstraint constraintWithItem:_companyLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:companyRight];
    
    NSLayoutConstraint *companyLeft = [NSLayoutConstraint constraintWithItem:_companyLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:companyLeft];
    
    return _companyLabel;
}

- (UILabel *)userLabel
{
    if (!_userLabel) {
        _userLabel = [[UILabel alloc] init];
    }
    _userLabel.textAlignment = NSTextAlignmentCenter;
    _userLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _userLabel.textColor = [UIColor whiteColor];
    [self addSubview:_userLabel];
    
    NSLayoutConstraint *userHeight = [NSLayoutConstraint constraintWithItem:_userLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
    [_userLabel addConstraint:userHeight];
    
    NSLayoutConstraint *userLeft = [NSLayoutConstraint constraintWithItem:_userLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self addConstraint:userLeft];
    
    NSLayoutConstraint *userRight = [NSLayoutConstraint constraintWithItem:_userLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.numberLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self addConstraint:userRight];
    
    NSLayoutConstraint *userBottom = [NSLayoutConstraint constraintWithItem:_userLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:userBottom];
    
    NSLayoutConstraint *userWidth = [NSLayoutConstraint constraintWithItem:_userLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.numberLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [self addConstraint:userWidth];
    
    return _userLabel;
}

- (UILabel *)numberLabel
{
    if (!_numberLabel) {
        _numberLabel = [[UILabel alloc] init];
    }
    _numberLabel.textAlignment = NSTextAlignmentCenter;
    _numberLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _numberLabel.textColor = [UIColor whiteColor];
    [self addSubview:_numberLabel];
    
    
    NSLayoutConstraint *numberHeight = [NSLayoutConstraint constraintWithItem:_numberLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
    [_numberLabel addConstraint:numberHeight];
    
    NSLayoutConstraint *numberLeft = [NSLayoutConstraint constraintWithItem:_numberLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_userLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:numberLeft];
    
    NSLayoutConstraint *numberRight = [NSLayoutConstraint constraintWithItem:_numberLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:numberRight];
    
    NSLayoutConstraint *numberBottom = [NSLayoutConstraint constraintWithItem:_numberLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:numberBottom];
    
    return _numberLabel;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
