//
//  HomeHeaderView.m
//  redstar
//
//  Created by admin on 15/10/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeHeaderView.h"
#define ImageCount 5

@interface HomeHeaderView () <UIScrollViewDelegate>
@property (nonatomic, strong) UIView *bgView; // 背景View
@end

@implementation HomeHeaderView

#pragma mark - init
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = kMineBackGroundColor;
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    [self.customPageControl setNumberOfPages:2];
    self.bgView.backgroundColor = [UIColor whiteColor];

}


#pragma mark - UIScrollView Delegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView {
    CGFloat pageWidth = _scrollView.bounds.size.width;
    float fractionalPage = _scrollView.contentOffset.x / pageWidth;
    NSInteger nearestNumber = lround(fractionalPage);
    
    if (_customPageControl.currentPage != nearestNumber) {
        _customPageControl.currentPage = nearestNumber;
        // 当scrollView在滑动
        if (_scrollView.dragging) {
            // 更新选中的小点点的位置
            [_customPageControl updateCurrentPageDisplay];
        }
    }
}

- (void)scrollViewDidEndScrollingAnimation:(UIScrollView *)scrollView {
    [_customPageControl updateCurrentPageDisplay] ;
}


- (UIView *)bgView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] init];
        _bgView.translatesAutoresizingMaskIntoConstraints = NO;
        _bgView.layer.borderWidth = 0.5;
        _bgView.layer.borderColor = kSeparateLineCGColor;
        [self addSubview:_bgView] ;
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:bgImageLeft];
    }
    
    return _bgView;
}

- (UIScrollView *)scrollView
{
    if (!_scrollView) {
        _scrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, 120)];
        _scrollView.bounces = NO;
        _scrollView.backgroundColor = [UIColor whiteColor];
        _scrollView.pagingEnabled = YES;
        _scrollView.delegate = self;
        _scrollView.showsHorizontalScrollIndicator = NO;
        _scrollView.showsVerticalScrollIndicator = NO;
        [self addSubview:_scrollView];
    }
    return _scrollView;
}

- (CustomPageControl *)customPageControl
{
    if (!_customPageControl) {
        _customPageControl = [[CustomPageControl alloc] init];
        _customPageControl.translatesAutoresizingMaskIntoConstraints = NO;
        _customPageControl.backgroundColor = [UIColor clearColor];
        [_customPageControl setCenter: CGPointMake(self.bgView.center.x, self.bgView.bounds.size.height-7.5f)] ;
        [_customPageControl setCurrentPage:0] ;
        [_customPageControl setDefersCurrentPageDisplay: YES] ;
        [_customPageControl setOnColor:kLineColor] ;
        [_customPageControl setOffColor:kLineColor] ;
        [_customPageControl setIndicatorDiameter:7.5f] ;
        [_customPageControl setIndicatorSpace:8.0f] ;
        [self.bgView addSubview:_customPageControl];
        
        NSLayoutConstraint *bgImageHeight = [NSLayoutConstraint constraintWithItem:_customPageControl attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:10];
        [self.bgView addConstraint:bgImageHeight];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_customPageControl attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.bgView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_customPageControl attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
        [self.bgView addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_customPageControl attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.bgView addConstraint:bgImageLeft];
        
    }
    
    return _customPageControl;
}

@end
