//
//  RankListHeaderView.m
//  redstar
//
//  Created by admin on 15/11/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankListHeaderView.h"
#import "RankListModel.h"


@interface RankListHeaderView ()
{
    UIView *_bgView;
    UIImageView *_arrowImageView;
    UIButton *_bgButton;
    UIButton *_otherButton;
    UILabel *_scoreLabel;
    NSInteger _section;
    UILabel *_gradeLabel;
    UIImageView *_gradeImageView;
}

@end

@implementation RankListHeaderView
+ (instancetype)headViewWithTableView:(UITableView *)tableView section:(NSInteger)section
{
    static NSString *headIdentifier = @"header";
    
    RankListHeaderView *headView = (RankListHeaderView *)[tableView dequeueReusableCellWithIdentifier:headIdentifier];
    if (headView == nil) {
        headView = [[RankListHeaderView alloc] initWithReuseIdentifier:headIdentifier section:(NSInteger)section];
    }
    
    return headView;
}

- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier section:(NSInteger)section
{
    if (self = [super initWithReuseIdentifier:reuseIdentifier]) {
        
        UIView *bgView = [[UIView alloc] init];
        bgView.backgroundColor = [UIColor whiteColor];
        [self addSubview:bgView];
        _bgView = bgView;
        
        
        UIButton *bgButton = [UIButton buttonWithType:UIButtonTypeCustom];
        bgButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        bgButton.contentEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 10);
        bgButton.titleEdgeInsets = UIEdgeInsetsMake(0, 45, 0, 0);
        [bgButton setTitleColor:kLightBlack forState:UIControlStateNormal];
        bgButton.titleLabel.font = [UIFont systemFontOfSize:18.0];
        [bgButton addTarget:self action:@selector(headBtnClick) forControlEvents:UIControlEventTouchUpInside];
        bgButton.backgroundColor = [UIColor whiteColor];
        [self addSubview:bgButton];
        _bgButton = bgButton;
        
        UIImageView *arrowIMView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"grey-trilateral_right"]];
        [self addSubview:arrowIMView];
        _arrowImageView = arrowIMView;
        
        UILabel *scoreLabel = [[UILabel alloc] init];
        scoreLabel.textAlignment = NSTextAlignmentCenter;
        scoreLabel.textColor = kNavigationBarColor;
        scoreLabel.font = [UIFont systemFontOfSize:17.0];
        [self addSubview:scoreLabel];
        _scoreLabel = scoreLabel;
        
        if (section < 3) {
            
            UIImageView *gradeImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", (int)section + 1]]];
            [self addSubview:gradeImageView];
            _gradeImageView = gradeImageView;
           
        
        } else {
            UILabel *gradeLabel = [[UILabel alloc] init];
            gradeLabel.textAlignment = NSTextAlignmentCenter;
            gradeLabel.textColor = kLightBlack;
            gradeLabel.font = [UIFont systemFontOfSize:16.0];
            [self addSubview:gradeLabel];
            gradeLabel.text = [NSString stringWithFormat:@"第%d名", (int)section + 1];
            _gradeLabel = gradeLabel;
        }
        _section = section;
        
        UIButton *pushButton = [UIButton buttonWithType:UIButtonTypeCustom];
        pushButton.tag = kPushTag + section;
        [_bgView addSubview:pushButton];
        _pushButton = pushButton;
        
    }
    
    return self;
}

- (void)headBtnClick
{
    _rankListModel.opened = !_rankListModel.isOpened;
    if ([_delegate respondsToSelector:@selector(clickHeadView)]) {
        [_delegate clickHeadView];
    }
}

- (void)setRankListModel:(RankListModel *)rankListModel
{
    _rankListModel = rankListModel;
    [_bgButton setTitle:rankListModel.store_name forState:UIControlStateNormal];
    _scoreLabel.text = [NSString stringWithFormat:@"%@ 分",rankListModel.score];
    
}


- (void)didMoveToSuperview
{
    if (_rankListModel.isOpened) {
        [UIView animateWithDuration:0.2 animations:^{
            _arrowImageView.transform = CGAffineTransformIdentity;
            _arrowImageView.transform = CGAffineTransformMakeRotation(M_PI / 2);
        }];

    } else {
        [UIView animateWithDuration:0.2 animations:^{
            _arrowImageView.transform = CGAffineTransformIdentity;
            _arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    _bgView.frame = self.bounds;
    _bgButton.frame = CGRectMake(30, 0, 0.3 * kScreenWidth, self.bounds.size.height);
    _arrowImageView.frame = CGRectMake(20, (self.frame.size.height - 11) / 2, 9, 10);
    _scoreLabel.frame = CGRectMake(0.4 * kScreenWidth, 0, 0.3 * kScreenWidth, 50);
    if (_section < 3) {
        _gradeImageView.frame = CGRectMake(0.8 * kScreenWidth, 9, 36, 33);
    } else {
        _gradeLabel.frame = CGRectMake(0.7 * kScreenWidth, 0, 0.3 * kScreenWidth, 50);
    }
    _pushButton.frame = CGRectMake(30 + 0.3 * kScreenWidth, 0, 0.7 * kScreenWidth - 30, self.bounds.size.height);;
    
}





@end
