//
//  RankingListCell.m
//  redstar
//
//  Created by admin on 15/10/28.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankingListCell.h"
#import "RankListModel.h"

@implementation RankingListCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
        _isDrop = NO;
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_right"];
    self.shopNameButton.titleLabel.font = [UIFont systemFontOfSize:18.0];
    self.scoreLabel.textColor = kDateButtonTextColor;
    self.gradeView.backgroundColor = [UIColor clearColor];
}

- (void)setRankList:(RankListModel *)rankList
{
    _rankList = rankList;
    [self.shopNameButton setTitle:[NSString stringWithFormat:@"%@", rankList.store_name] forState:UIControlStateNormal];
    self.scoreLabel.text = [NSString stringWithFormat:@"%@", rankList.score];

}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

#pragma mark - setter方法
- (void)setScoreState:(ScoreState)scoreState
{
    _scoreState = scoreState;
    if (self.scoreState == ScoreStateHigh) {
        self.gradeImageView.backgroundColor = [UIColor clearColor];
    } else {
        self.gradeLabel.textColor = kScoreTextColor;
    }
}

#pragma mark - Layz loading

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView insertSubview:_arrowImageView aboveSubview:self.shopNameButton];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:19];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.shopNameButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:10];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:8];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _arrowImageView;
}

- (UIButton *)shopNameButton
{
    if (!_shopNameButton) {
        _shopNameButton = [[UIButton alloc] init];
        _shopNameButton.translatesAutoresizingMaskIntoConstraints = NO;
        _shopNameButton.titleLabel.textAlignment = NSTextAlignmentCenter;
        [_shopNameButton setTitleColor:kShopNameTextColor forState:UIControlStateNormal];
        [self.contentView addSubview:_shopNameButton];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_shopNameButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_shopNameButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:10];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_shopNameButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_shopNameButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:shoppingHeight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_shopNameButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeWidth multiplier:1.2 constant:0];
        [self.contentView addConstraint:shoppingWidth];


    }
    return _shopNameButton;
}

- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _scoreLabel.textAlignment = NSTextAlignmentCenter;
        _scoreLabel.font = [UIFont systemFontOfSize:17.0];

        [self.contentView addSubview:_scoreLabel];
        NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.contentView addConstraint:scoreTop];
        
        NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:scoreRight];
        
        NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:scoreWidth];
        
        NSLayoutConstraint *scoreHeight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:scoreHeight];
    }
    return _scoreLabel;
}

- (UIView *)gradeView
{
    if (!_gradeView) {
        _gradeView = [[UIView alloc] init];
        _gradeView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_gradeView];
    }
    
    //
    NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
    [self.contentView addConstraint:gradeTop];
    
    NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.contentView addConstraint:gradeRight];
    
    NSLayoutConstraint *gradeHeight = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
    [self.contentView addConstraint:gradeHeight];
    
    return _gradeView;
}

- (UILabel *)gradeLabel
{
    if (!_gradeLabel) {
        _gradeLabel = [[UILabel alloc] init];
        _gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _gradeLabel.textAlignment = NSTextAlignmentCenter;
        [self.gradeView addSubview:_gradeLabel];
        
        //
        NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeTop];
        
        NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeRight];
        
        NSLayoutConstraint *gradeBottom = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeBottom];
        
        NSLayoutConstraint *gradeLeft = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeLeft];
    }
    return _gradeLabel;
}

- (UIImageView *)gradeImageView
{
    if (!_gradeImageView) {
        _gradeImageView = [[UIImageView alloc] init];
        _gradeImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.gradeView addSubview:_gradeImageView];
        
        //
        NSLayoutConstraint *gradeCenterX = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeCenterX];
        
        NSLayoutConstraint *gradeCenterY = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeCenterY multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeCenterY];
        
        NSLayoutConstraint *gradeWidth = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self.gradeView addConstraint:gradeWidth];
        
        NSLayoutConstraint *gradeHeight = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:34];
        [self.gradeView addConstraint:gradeHeight];
    }
    return _gradeImageView;
}

@end
