//
//  RankCommentCell.m
//  redstar
//
//  Created by admin on 15/11/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankCommentCell.h"

@interface RankCommentCell ()


@end

@implementation RankCommentCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        
    }
    return self;
}

- (void)setRankComment:(RankCommentModel *)rankComment
{
    _rankComment = rankComment;
    self.peopleLabel.text = [NSString stringWithFormat:@"%@", rankComment.commentor_name];
    self.dateLabel.text = [NSString stringWithFormat:@"%@", rankComment.commentTime];
    self.commentLabel.text = [NSString stringWithFormat:@"评论：%@", rankComment.comment];
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.font = [UIFont systemFontOfSize:15.0];
        _peopleLabel.textColor = kRankHeadTitleTextColor;
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_peopleLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-20];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:30];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _peopleLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.font = [UIFont systemFontOfSize:15.0];
        _dateLabel.textColor = kRankHeadTitleTextColor;
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_dateLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-20];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _dateLabel;
}


- (UILabel *)commentLabel
{
    if (!_commentLabel) {
        _commentLabel = [[UILabel alloc] init];
        _commentLabel.font = [UIFont systemFontOfSize:15.0];
        _commentLabel.textColor = kRankHeadTitleTextColor;
        _commentLabel.numberOfLines = 0;
        _commentLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_commentLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.peopleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:30];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _commentLabel;
}


- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
