//
//  TakePhotoView.m
//  test
//
//  Created by admin on 15/11/21.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "TakePhotoView.h"
#import "CheckPicViewController.h"

#define kScreenWidth   [UIScreen mainScreen].bounds.size.width
#define imageH 110 // 图片高度
#define imageW (kScreenWidth - 3 * 20) / 2 // 图片宽度
#define kMaxColumn 2 // 每行显示数量
#define MaxImageCount 9 // 最多显示图片个数
#define deleImageWH 25 // 删除按钮的宽高
#define kAdeleImage @"close.png" // 删除按钮图片
#define kAddImage @"add-photos_btn" // 添加按钮图片


@interface TakePhotoView ()


@end


@implementation TakePhotoView
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UIImage *image = [UIImage imageNamed:kAddImage];
        UIButton *btn = [self createButtonWithImage:image];
        btn.backgroundColor = [UIColor whiteColor];
        [btn addTarget:self action:@selector(addNewButton:) forControlEvents:UIControlEventTouchUpInside];

        [btn setTitleColor:kLightGray forState:UIControlStateNormal];
        [self addSubview:btn];
        
        self.allImages = [NSMutableArray array];
    }
    return self;
}

- (UIButton *)createButtonWithImage:(UIImage *)image
{
    UIButton *addBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [addBtn setImage:image forState:UIControlStateNormal];
    addBtn.imageEdgeInsets = UIEdgeInsetsMake(2, 2, 2, 2);
    addBtn.tag = self.subviews.count;
    addBtn.backgroundColor = [UIColor whiteColor];
    addBtn.layer.borderWidth = 0.5;
    addBtn.layer.borderColor = kSeparateLineCGColor;
    // 添加长按手势,用作删除.  加号按钮不添加
    if(addBtn.tag != 0) {
        UILongPressGestureRecognizer *gester = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
        [addBtn addGestureRecognizer:gester];
    }
    return addBtn;
}


// 添加显示Image的按钮
- (void)addNewButton:(UIButton *)button
{
    // 创建相机、或拉出相册
    if (![self removeDeleteButton:button]) {
        [self createImagePickerController];
    }
}

// 创建相册
- (void)createImagePickerController
{
    if (_delegate && [_delegate respondsToSelector:@selector(createImagePicker)]) {
        [_delegate createImagePicker];
    }
}

- (void)longPress:(UIGestureRecognizer *)gestureRecognizer
{
    if (gestureRecognizer.state == UIGestureRecognizerStateBegan)  {
        
        // 获取到点击的显示图片的按钮
        UIButton *showButton = (UIButton *)gestureRecognizer.view;
        
        // 创建长按删除的按钮
        UIButton *deleteButton = [UIButton buttonWithType:UIButtonTypeCustom];
        deleteButton.backgroundColor = [UIColor redColor];
        deleteButton.bounds = CGRectMake(0, 0, deleImageWH, deleImageWH);
        [deleteButton setImage:[UIImage imageNamed:kAdeleImage] forState:UIControlStateNormal];
        [deleteButton addTarget:self action:@selector(deletePicture:) forControlEvents:UIControlEventTouchUpInside];
        deleteButton.frame = CGRectMake(showButton.frame.size.width - deleteButton.frame.size.width, 0, deleteButton.frame.size.width, deleteButton.frame.size.height);
        [showButton addSubview:deleteButton];
    }
}

// 删除图片
- (void)deletePicture:(UIButton *)button
{
    
    if (_delegate && [_delegate respondsToSelector:@selector(deletePhoto:)]) {
        [_delegate deletePhoto:button];
    }
}

// 对所有子控件进行布局
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    // 子控件的个数
    int count = (int)self.subviews.count;
    
    // 设置button的宽 高 间隔
    CGFloat btnW = imageW;
    CGFloat btnH = imageH;
    CGFloat marginX = 20;
    CGFloat marginY = 10;
    
    // 设置frame 每行两个 满2个换行
    for (int i = 0; i < count; i++) {
        UIButton *btn = self.subviews[i];
        CGFloat btnX;
        CGFloat btnY;
        if (i % 2 == 0) {
            btnX = marginX;
            int k = (int)floor(i / 2);
            btnY = (10 + k * (imageH + marginY));
        } else {
            btnX = marginX + imageW + marginX;
            int k = (int)floor(i / 2);
            btnY = (10 + k * (imageH + marginY));
        }
        btn.frame = CGRectMake(btnX, btnY, btnW, btnH);
    }
}

// 当点击显示图片按钮的其他位置的时候 删除"删除按钮"
- (BOOL)removeDeleteButton:(UIButton *)button
{
    if (button.subviews.count == 2) {
        [[button.subviews lastObject] removeFromSuperview];
        return YES;
    }
    return NO;
}


// 修改已经拍好照片的旧控件
- (void)lookStill:(UIButton *)button
{
    if (![self removeDeleteButton:button]) {
        
    }
}


@end
