//
//  RankListHeaderView.m
//  redstar
//
//  Created by admin on 15/11/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankListHeaderView.h"
#import "RankListModel.h"


@interface RankListHeaderView ()
{
    UIView *_bgView;
    UIImageView *_arrowImageView;
    UIButton *_bgButton;
    UIButton *_otherButton;
    UILabel *_scoreLabel;
    NSInteger _section;
    NSInteger _index;

    UILabel *_gradeLabel;
    UIImageView *_gradeImageView;
    UIView *_lineView;

}

@end

@implementation RankListHeaderView
+ (instancetype)headViewWithTableView:(UITableView *)tableView section:(NSInteger)section index:(int)index
{
    static NSString *headIdentifier = @"header";
    
    RankListHeaderView *headView = (RankListHeaderView *)[tableView dequeueReusableCellWithIdentifier:headIdentifier];
    if (headView == nil) {
        headView = [[RankListHeaderView alloc] initWithReuseIdentifier:headIdentifier section:(NSInteger)section index:index];
    }
    
    return headView;
}

- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier section:(NSInteger)section index:(int)index
{
    if (self = [super initWithReuseIdentifier:reuseIdentifier]) {
        
        UIView *bgView = [[UIView alloc] init];
        bgView.backgroundColor = [UIColor whiteColor];
        [self addSubview:bgView];
        _bgView = bgView;
        
        
        UIButton *bgButton = [UIButton buttonWithType:UIButtonTypeCustom];
        bgButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        bgButton.contentEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 10);
        bgButton.titleEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 0);
        [bgButton setTitleColor:kLightBlack forState:UIControlStateNormal];
        bgButton.titleLabel.font = [UIFont systemFontOfSize:17.0];
        [bgButton addTarget:self action:@selector(headBtnClick) forControlEvents:UIControlEventTouchUpInside];
        bgButton.backgroundColor = [UIColor whiteColor];
        bgButton.titleLabel.numberOfLines = 0;
        [self addSubview:bgButton];
        _bgButton = bgButton;
        
        UIImageView *arrowIMView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"grey-trilateral_right"]];
        [self addSubview:arrowIMView];
        _arrowImageView = arrowIMView;
        
        UILabel *scoreLabel = [[UILabel alloc] init];
        scoreLabel.textAlignment = NSTextAlignmentCenter;
        scoreLabel.textColor = kNavigationBarColor;
        scoreLabel.font = [UIFont systemFontOfSize:17.0];
        [self addSubview:scoreLabel];
        _scoreLabel = scoreLabel;
        
        if (index <= 3) {
            UIImageView *gradeImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", index]]];
            [self addSubview:gradeImageView];
            _gradeImageView = gradeImageView;
           
        
        } else {
            UILabel *gradeLabel = [[UILabel alloc] init];
            gradeLabel.textAlignment = NSTextAlignmentCenter;
            [self addSubview:gradeLabel];
            
            NSString *rankStr = [NSString stringWithFormat:@"第 %d 名", index];
            NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
            [gradeLabel setAttributedText:rankAttr];
            _gradeLabel = gradeLabel;
        }
        _section = section;
        _index = index;
        
        UIButton *pushButton = [UIButton buttonWithType:UIButtonTypeCustom];
        pushButton.tag = kPushTag + section;
        [_bgView addSubview:pushButton];
        _pushButton = pushButton;
        
        UIView *lineView = [[UIView alloc] init];
        [self addSubview:lineView];
        lineView.backgroundColor = kSeparateLineColor;
        _lineView = lineView;
        
    }
    
    return self;
}

- (void)headBtnClick
{
    _rankListModel.opened = !_rankListModel.isOpened;
    if ([_delegate respondsToSelector:@selector(clickHeadView)]) {
        [_delegate clickHeadView];
    }
}

- (void)setRankListModel:(RankListModel *)rankListModel
{
    _rankListModel = rankListModel;
    [_bgButton setTitle:rankListModel.store_name forState:UIControlStateNormal];
    
    if (rankListModel.score == 0) {
        _scoreLabel.text = [NSString stringWithFormat:@"0"];
    } else {
        _scoreLabel.text = [NSString stringWithFormat:@"%.1f",rankListModel.score];
    }
}


- (void)didMoveToSuperview
{
    if (_rankListModel.isOpened) {
        [UIView animateWithDuration:0.2 animations:^{
            _arrowImageView.transform = CGAffineTransformIdentity;
            _arrowImageView.transform = CGAffineTransformMakeRotation(M_PI / 2);
        }];

    } else {
        [UIView animateWithDuration:0.2 animations:^{
            _arrowImageView.transform = CGAffineTransformIdentity;
            _arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    _bgView.frame = self.bounds;
    _bgButton.frame = CGRectMake(30, 0, 0.35 * kScreenWidth, self.bounds.size.height);
    _arrowImageView.frame = CGRectMake(20, (self.frame.size.height - 11) / 2, 9, 10);
    _scoreLabel.frame = CGRectMake(0.4 * kScreenWidth, 0, 0.25 * kScreenWidth, 50);
    if (_index <= 3) {
        _gradeImageView.frame = CGRectMake(0.8 * kScreenWidth, 9, 36, 33);
    } else {
        _gradeLabel.frame = CGRectMake(0.7 * kScreenWidth, 0, 0.3 * kScreenWidth, 50);
    }
    _pushButton.frame = CGRectMake(30 + 0.3 * kScreenWidth, 0, 0.7 * kScreenWidth - 30, self.bounds.size.height);;
    _lineView.frame = CGRectMake(0, self.bounds.size.height - 0.5, kScreenWidth, 0.5);
}





@end
