//
//  RankingListViewController.m
//  redstar
//
//  Created by admin on 15/10/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankingListViewController.h"
#import "RankingListCell.h"
#import "RankDetailViewController.h"

#import "HttpClient.h"
#import "RankListModel.h"
#import "NoDataView.h"
#import "RankCommentModel.h"
#import "RankListHeaderView.h"

#import "RankCommentCell.h"

#import <MBProgressHUD.h>

#define kRankingCell @"RankingTableViewCell"
#define kShopNameBtnTag 15000

@interface RankingListViewController () <UITableViewDataSource, UITableViewDelegate, RankListHeaderDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) UIView *headView;
@property (nonatomic, strong) UIView *lineView1;

@property (nonatomic, strong) NSMutableArray *allRankListArray;
@property (nonatomic, strong) NoDataView *noDataView;

@property (nonatomic, strong) UILabel *shoppingLabel;
@property (nonatomic, strong) UILabel *scoreLabel;
@property (nonatomic, strong) UILabel *gradeLabel;

@property (nonatomic, strong) NSArray *rankData;

@end

@implementation RankingListViewController

#pragma mark - ViewDidLoad
- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑排名"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;

    self.allRankListArray = [NSMutableArray array];

    if([[[UIDevice currentDevice]systemVersion]floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
    }
    
   

    [self addTableViews];
    
    [self requestRankingList];
    
    self.shoppingLabel.text = @"商场名称";
    self.scoreLabel.text = @"总分";
    self.gradeLabel.text = @"排名";

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = YES;
}

#pragma mark - Private Methods
- (void)requestRankingList
{
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    
    NSDictionary *parameters = @{@"beginDateFrom":@"",
                                 @"endDateTo":@"",
                                 @"queryOrders":@[],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(10)
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    __block RankingListViewController *weakSelf = self;
    [httpCilent getRankingListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"口碑排名response = %@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        
        NSMutableArray *tgArray = [NSMutableArray array];

        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [tgArray addObject:rankList];
        }
        _rankData = (NSMutableArray *)[self sortRankListWithRankListArray:tgArray];
        
        
        if (_rankData.count == 0) {
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:self.view animated:YES];

        } else {
        
            self.tableView.delegate = self;
            self.tableView.dataSource = self;
            NSString *shopCount = [NSString stringWithFormat:@"%lu 家", (unsigned long)_rankData.count];
            NSMutableAttributedString *shopAttr = [[NSMutableAttributedString alloc] initWithString:shopCount];
            [shopAttr addAttributes:@{NSForegroundColorAttributeName:kShopCountTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(0,shopCount.length - 2)];
            [shopAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(shopCount.length - 2,2)];
            _shoppingCountLabel.attributedText = shopAttr;
            [MBProgressHUD hideHUDForView:self.view animated:YES];

        }
    }];
}

- (NSArray *)sortRankListWithRankListArray:(NSMutableArray *)allRanking
{
    NSArray *sortedArray = [allRanking sortedArrayUsingComparator:^NSComparisonResult(RankListModel *p1, RankListModel *p2){
        return [p2.score compare:p1.score];
    }];
    return sortedArray;
}

-(void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)addTableViews
{
    self.pointLabel1.text = @"月度排名";
    self.lineView.backgroundColor = kSeparateLineColor;
    self.pointLabel2.text = @"参与商家数量";
    self.lineView1.backgroundColor = kSeparateLineColor;
    self.shoppingCountLabel.textAlignment = NSTextAlignmentCenter;
    [self.dateButton addTarget:self action:@selector(changeDateClick:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)changeDateClick:(DateButton *)sender
{
    
}


#pragma mark - UITableView DataSource/Delegate

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _rankData.count;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    RankListModel *rankList = _rankData[section];
    NSInteger count = rankList.isOpened ? rankList.comments.count: 0;
    return count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RankCommentCell *cell=[tableView dequeueReusableCellWithIdentifier:kRankingCell];
    if (!cell) {
        cell = [[RankCommentCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankingCell];
    }
    RankListModel *rankListModel = _rankData[indexPath.section];
    RankCommentModel *commentModel = rankListModel.comments[indexPath.row];
    cell.rankComment = commentModel;
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    RankListModel *rankList = _rankData[indexPath.section];
    
    RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
    rankDetailVC.indexRow = indexPath.section;
    rankDetailVC.uuid = rankList.uuid;
    rankDetailVC.store_uuid = rankList.store_uuid;
    rankDetailVC.storeAddress = rankList.storeAddress;
    rankDetailVC.storePictures = rankList.storePictures;
    [self.navigationController pushViewController:rankDetailVC animated:YES];
}

// cell的高度

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 50;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    RankListHeaderView *headView = [RankListHeaderView headViewWithTableView:tableView section:section];
    headView.delegate = self;
    [headView.pushButton addTarget:self action:@selector(pushclick:) forControlEvents:UIControlEventTouchUpInside];
    headView.rankListModel = _rankData[section];
    return headView;
}

- (void)pushclick:(UIButton *)sender
{
    NSInteger section = sender.tag - kPushTag;
    
    RankListModel *rankList = _rankData[section];
    
    RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
    rankDetailVC.indexRow = section;
    rankDetailVC.uuid = rankList.uuid;
    rankDetailVC.store_uuid = rankList.store_uuid;
    rankDetailVC.storeAddress = rankList.storeAddress;
    NSLog(@"storeAddress = %@", rankList.storePictures);
    rankDetailVC.storePictures = rankList.storePictures;
    [self.navigationController pushViewController:rankDetailVC animated:YES];
}


#pragma mark - lazy loading
- (UILabel *)pointLabel1
{
    if (!_pointLabel1) {
        _pointLabel1 = [[UILabel alloc] init];
        _pointLabel1.translatesAutoresizingMaskIntoConstraints = NO;
        _pointLabel1.textColor = kRankHeadTitleTextColor;
        _pointLabel1.font = [UIFont systemFontOfSize:15.0];
        _pointLabel1.textAlignment = NSTextAlignmentCenter;
        [self.headView addSubview:_pointLabel1];
        
        NSLayoutConstraint *point1Top = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7];
        [self.headView addConstraint:point1Top];
        
        NSLayoutConstraint *point1Right = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:15];
        [self.headView addConstraint:point1Right];
        
        NSLayoutConstraint *point1Left = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:point1Left];
        
        NSLayoutConstraint *point1Height = [NSLayoutConstraint constraintWithItem:_pointLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.headView addConstraint:point1Height];
    }
    return _pointLabel1;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc] init];
        _lineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_lineView];
        
        NSLayoutConstraint *point1Top = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.headView addConstraint:point1Top];
        
        
        
        NSLayoutConstraint *point1Left = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pointLabel1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:point1Left];
        
        NSLayoutConstraint *point1Height = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.headView addConstraint:point1Height];
        
        NSLayoutConstraint *point1Width = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
        [self.headView addConstraint:point1Width];
        
    }
    return _lineView;
}


- (UILabel *)pointLabel2
{
    if (!_pointLabel2) {
        _pointLabel2 = [[UILabel alloc] init];
        _pointLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _pointLabel2.textColor = kRankHeadTitleTextColor;
        _pointLabel2.font = [UIFont systemFontOfSize:15.0];
        _pointLabel2.textAlignment = NSTextAlignmentCenter;
        [self.headView addSubview:_pointLabel2];
        
        NSLayoutConstraint *point1Top = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7];
        [self.headView addConstraint:point1Top];
        
        NSLayoutConstraint *point1Right = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-(kScreenWidth / 2 - 15 - 90) / 2];
        [self.headView addConstraint:point1Right];
        
        
        NSLayoutConstraint *point1Height = [NSLayoutConstraint constraintWithItem:_pointLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.headView addConstraint:point1Height];
    }
    return _pointLabel2;
}


- (DateButton *)dateButton
{
    if (!_dateButton) {
        _dateButton = [[DateButton alloc] init];
        _dateButton.translatesAutoresizingMaskIntoConstraints = NO;
        
        NSString *dateStr = [NSString stringWithFormat:@"2015 年 08 月"];
        NSMutableAttributedString *dateAttr = [[NSMutableAttributedString alloc] initWithString:dateStr];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:kDateButtonTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(0,5)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(5,1)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:kDateButtonTextColor,NSFontAttributeName:[UIFont systemFontOfSize:21.0f]} range:NSMakeRange(6,4)];
        [dateAttr addAttributes:@{NSForegroundColorAttributeName:[UIColor blackColor],NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(10,1)];
        [_dateButton setAttributedTitle:dateAttr forState:UIControlStateNormal];
        
        [self.headView addSubview:_dateButton];
        
        NSLayoutConstraint *dateTop = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pointLabel1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:dateTop];
        
        NSLayoutConstraint *dateLeft = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pointLabel1 attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-70];
        [self.headView addConstraint:dateLeft];
        
        NSLayoutConstraint *dateWidth = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:150];
        [self.headView addConstraint:dateWidth];
        
        NSLayoutConstraint *dateHeight = [NSLayoutConstraint constraintWithItem:_dateButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [_dateButton addConstraint:dateHeight];
    }
    return _dateButton;
}

- (UILabel *)shoppingCountLabel
{
    if (!_shoppingCountLabel) {
        _shoppingCountLabel = [[UILabel alloc] init];
        _shoppingCountLabel.translatesAutoresizingMaskIntoConstraints = NO;
        
        [self.headView addSubview:_shoppingCountLabel];
        
        NSLayoutConstraint *shoppingCountTop = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pointLabel2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingCountTop];
        
        NSLayoutConstraint *shoppingCountRight = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-(kScreenWidth / 2  - 60) / 2];
        [self.headView addConstraint:shoppingCountRight];
        
        NSLayoutConstraint *shoppingCountHeight = [NSLayoutConstraint constraintWithItem:_shoppingCountLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [_shoppingCountLabel addConstraint:shoppingCountHeight];
    }
    return _shoppingCountLabel;
}


- (UIView *)lineView1
{
    if (!_lineView1) {
        _lineView1 = [[UIView alloc] init];
        _lineView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_lineView1];
        
        NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:75];
        [self.headView addConstraint:lineBottom];
        
        NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:lineLeft];
        
        NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:lineRight];
        
        NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [_lineView1 addConstraint:lineHeight];
    }
    return _lineView1;
}

- (UIView *)headView
{
    if (!_headView) {
        _headView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 116)];
        _headView.backgroundColor = [UIColor whiteColor];
    }
    return _headView;
}

- (UILabel *)shoppingLabel
{
    if (!_shoppingLabel) {
        // 商场
        _shoppingLabel = [[UILabel alloc] init];
        _shoppingLabel.textAlignment = NSTextAlignmentCenter;
        _shoppingLabel.textColor = kRankHeadTitleTextColor;
        _shoppingLabel.backgroundColor = kSectionBackGroundColor;

        _shoppingLabel.font = [UIFont systemFontOfSize:17.0];
        _shoppingLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_shoppingLabel];
        
        //
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_shoppingLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:76];
        [self.headView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_shoppingLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_shoppingLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:_shoppingLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:shoppingBottom];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_shoppingLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeWidth multiplier:1.2 constant:0];
        [self.headView addConstraint:shoppingWidth];
    }
    return _shoppingLabel;
}

- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.textAlignment = NSTextAlignmentCenter;
        _scoreLabel.textColor = kRankHeadTitleTextColor;
        _scoreLabel.backgroundColor = kSectionBackGroundColor;
        _scoreLabel.font = [UIFont systemFontOfSize:17.0];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.headView addSubview:_scoreLabel];
        
        //
        NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:76];
        [self.headView addConstraint:scoreTop];
        
        NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.headView addConstraint:scoreRight];
        
        NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.gradeLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.headView addConstraint:scoreWidth];
        
        NSLayoutConstraint *scoreBottom = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:scoreBottom];
    }
    return _scoreLabel;
}

- (UILabel *)gradeLabel
{
    if (!_gradeLabel) {
        _gradeLabel = [[UILabel alloc] init];
        _gradeLabel.textAlignment = NSTextAlignmentCenter;
        _gradeLabel.textColor = kRankHeadTitleTextColor;
        _gradeLabel.font = [UIFont systemFontOfSize:17.0];
        _gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _gradeLabel.backgroundColor = kSectionBackGroundColor;

        [self.headView addSubview:_gradeLabel];
        
        //
        NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeTop multiplier:1.0 constant:76];
        [self.headView addConstraint:gradeTop];
        
        NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.headView addConstraint:gradeRight];
        
        NSLayoutConstraint *gradeBottom = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.headView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.headView addConstraint:gradeBottom];
    }
    return _gradeLabel;
}











- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 100.0;
        [_tableView registerClass:[RankCommentCell class] forCellReuseIdentifier:kRankingCell];
        _tableView.tableHeaderView = self.headView;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}

- (void)clickHeadView
{
    [_tableView reloadData];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
