//
//  QuestionViewController.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionViewController.h"
#import "QuestionListTableCell.h"
#import "MenuButton.h"
#import "QuestionDetailViewController.h"
#import "AddQuestionViewController.h"
#import "HttpClient.h"
#import "QuestionModel.h"
#import "SearchToolBar.h"
#import "TaxisView.h"
#import "MoreScreenView.h"
#import "MenuView.h"
#import "CustomDropMenuView.h"

#import "NoDataView.h"
#import <MBProgressHUD.h>

#import <MJRefresh.h>

#define kQuestionListCell @"questionListTableViewCell"
#define kThumbTag 745645

@interface QuestionViewController () <UITableViewDelegate, UITableViewDataSource, TaxisViewDelegate, ScopeTableViewDelegate, GroupTableViewDelegate, CategoryTableViewDelegate, StateTableViewDelegate, TimeTableViewDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *allQuestionArray;

@property (nonatomic, strong) SearchToolBar *searchBar;
@property (nonatomic, strong) MenuView *menuView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) MoreScreenView *screenView;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, strong) MenuButton *selctedButton;
@property (nonatomic, strong) UIButton *selectBtn;

@property (nonatomic, strong) NoDataView *noDataView;

@property (nonatomic, assign) NSInteger page;

@property (nonatomic, assign) NSInteger scopeRow;
@property (nonatomic, assign) NSInteger groupRow;
@property (nonatomic, assign) NSInteger categoryRow;
@property (nonatomic, assign) NSInteger stateRow;
@property (nonatomic, assign) NSInteger timeRow;


@end

@implementation QuestionViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
   // [self requestQuestionList];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(requestQuestionList)
                                                 name:kRefreshQuestionNotification
                                               object:nil];
    
    _page = 0;
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.tabBarController.tabBar.hidden = YES;
    self.menuView.backgroundColor = kInspectSectionBackGroundColor;

    [self requestQuestionList];
}





- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods

- (void)requestQuestionList
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];

    // 请求参数
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(10)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block QuestionViewController *weakSelf = self;
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray  = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = [NSMutableArray arrayWithArray:tempArray];
        if (_allQuestionArray.count == 0) {
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        } else {
            [weakSelf setupTableView];
            
            self.tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
                [self requestMoreList];
            }];
            [self.tableView reloadData];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        }

        
    }];
}

- (void)requestMoreList
{
    _page++;
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    // 请求参数
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(_page),
                                 @"pageSize":@(10)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray  = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        [_allQuestionArray addObjectsFromArray:tempArray];
        
        if (tempArray.count < 5) {
            [self.tableView.footer noticeNoMoreData];
        } else {
            [self.tableView.footer endRefreshing];
        }
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;

        [self.tableView reloadData];
    }];

}

- (void)setupTableView
{
    [self.tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kQuestionListCell];
    
    self.searchBar.backgroundColor = kSectionBackGroundColor;
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题与知识"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"新增问题" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addQuestionClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)addQuestionClick:(UIButton *)sender
{
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500503"]) {
        AddQuestionViewController *addQuestionVC = [[AddQuestionViewController alloc] init];
        [self.navigationController pushViewController:addQuestionVC animated:YES];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有新增问题权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
    
    
}

- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            [sender setTitleColor:[UIColor orangeColor] forState:UIControlStateNormal];
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            [sender setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   1.将发生“选中”->“未选中”状态变化的按钮文字由Orange->White
        [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        //   1.将选中按钮的文字设置为Orange
        [sender setTitleColor:[UIColor orangeColor] forState:UIControlStateNormal];
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}


- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth, kScreenHeight)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    _taxisView.frame = toFrame;
    _taxisView.alpha = 0.0;
    [UIView animateWithDuration:0.2 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.alpha = 1.0;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.2 animations:^{
        _bgView.alpha = .0f;
        _taxisView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth, kScreenHeight)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[MoreScreenView alloc] init];
        _screenView.backgroundColor = [UIColor whiteColor];
        _screenView.scopeTableView.scopeDeleagte = self;
        _screenView.groupTableView.groupDeleagte = self;
        _screenView.categoryTableView.categroyDeleagte = self;
        _screenView.stateTableView.stateDeleagte = self;
        _screenView.timeTableView.timeDeleagte = self;
    }
    [_screenView.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [_screenView.submitBtn addTarget:self action:@selector(submitClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kMoreScreenViewHeight);
    _screenView.frame = toFrame;
    _screenView.alpha = 0.0;

    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.alpha = 1.0;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}


- (void)searchBarClick:(UIButton *)sender
{
    NSLog(@"%@", self.searchBar.searchTextFiled.text);
}

// 重置按钮
- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_screenView.scopeTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [_screenView.groupTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [_screenView.categoryTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [_screenView.stateTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [_screenView.timeTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    _screenView.textView1.text = @"";
    _screenView.textView2.text = @"";


}
// 提交按钮
- (void)submitClick:(UIButton *)sender
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
  
    NSMutableDictionary *parameters = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                       user_uuid,@"user",
                                       @(0),@"pageNumber",
                                       @(10),@"pageSize", nil];
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block QuestionViewController *weakSelf = self;
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    if (_screenView.groupTabBar.selectNumber == 0) {
        if (_scopeRow == 0) {
            [parameters setObject:@"all" forKey:@"scope"];
        } else {
            [parameters setObject:@"mine" forKey:@"scope"];
        }
        NSArray *array = @[@{@"field":@"scope",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    } else if (_screenView.groupTabBar.selectNumber == 1) {
        if (_groupRow == 0) {
            
        } else if (_groupRow == 1) {
            [parameters setObject:@"服务" forKey:@"group"];
        } else if (_groupRow == 2) {
            [parameters setObject:@"环境企划" forKey:@"group"];
        } else {
            [parameters setObject:@"环境物业" forKey:@"group"];
        }
        NSArray *array = @[@{@"field":@"group",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    } else if (_screenView.groupTabBar.selectNumber == 2) {
        if (_categoryRow == 0) {
            [parameters setObject:@"基础环境" forKey:@"category"];
        } else if (_categoryRow == 1) {
            [parameters setObject:@"人员" forKey:@"category"];
        } else if (_categoryRow == 2) {
            [parameters setObject:@"停车场" forKey:@"category"];
        } else if (_categoryRow == 3) {
            [parameters setObject:@"卫生间" forKey:@"category"];
        } else {
            [parameters setObject:@"物料标识" forKey:@"category"];
        }
        NSArray *array = @[@{@"field":@"category",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    } else if (_screenView.groupTabBar.selectNumber == 3) {
        [parameters setObject:_screenView.textView1.text forKey:@"contentLike"];
        NSArray *array = @[@{@"field":@"contentLike",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];

    } else if (_screenView.groupTabBar.selectNumber == 4) {
        [parameters setObject:_screenView.textView2.text forKey:@"keyword"];
        NSArray *array = @[@{@"field":@"keyword",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];

    } else if (_screenView.groupTabBar.selectNumber == 5) {
        if (_stateRow == 0) {
            [parameters setObject:@"created" forKey:@"state"];
        } else if (_stateRow == 1) {
            [parameters setObject:@"resolved" forKey:@"state"];
        } else {
            [parameters setObject:@"aborted" forKey:@"state"];
        }
        NSArray *array = @[@{@"field":@"state",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    } else if (_screenView.groupTabBar.selectNumber == 6) {
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
        
        // 当前时间
        NSDate *today = [NSDate date];
        NSString *todayStr = [dateFormatter stringFromDate:today];
        if (_timeRow == 0) {
            
        } else if (_timeRow == 1) {
            
            NSDate *week = [today dateByAddingTimeInterval:-60*60*24*7];
            NSString *weekStr = [dateFormatter stringFromDate:week];
            
            [parameters setObject:weekStr forKey:@"beginDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else if (_timeRow == 2) {
            
            NSDate *oneMonth = [self getPriousorLaterDateFromDate:today withMonth:-1];
            NSString *oneMonthStr = [dateFormatter stringFromDate:oneMonth];
            NSLog(@"oneMonth = %@", oneMonthStr);
            
            [parameters setObject:oneMonthStr forKey:@"beginDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
            
        } else if (_timeRow == 3) {
            NSDate *threeMonth = [self getPriousorLaterDateFromDate:today withMonth:-3];
            NSString *threeMonthStr = [dateFormatter stringFromDate:threeMonth];
            
            [parameters setObject:threeMonthStr forKey:@"beginDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else if (_timeRow == 4) {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            
            [parameters setObject:oneYearStr forKey:@"beginDateFrom"];
            [parameters setObject:todayStr forKey:@"endDateTo"];
        } else {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            [parameters setObject:oneYearStr forKey:@"endDateTo"];
        }
        
        NSArray *array = @[@{@"field":@"lastModifyInfo",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    }
    
    NSLog(@"parameters = %@",parameters);
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = tempArray;

        if (_allQuestionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            weakSelf.tableView.delegate = weakSelf;
            weakSelf.tableView.dataSource = weakSelf;
            [weakSelf.tableView reloadData];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        }
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;

    }];

}

- (NSDate *)getPriousorLaterDateFromDate:(NSDate *)date withMonth:(int)month
{
    NSDateComponents *comps = [[NSDateComponents alloc] init];
    [comps setMonth:month];
    NSCalendar *calender = [[NSCalendar alloc] initWithCalendarIdentifier:NSGregorianCalendar];
    NSDate *mDate = [calender dateByAddingComponents:comps toDate:date options:0];
    return mDate;
}

#pragma mark - MoreScreenDelegate
- (void)scopeTableViewClick:(NSInteger)row
{
    _scopeRow = row;
}

- (void)groupTableViewClick:(NSInteger)row
{
    _groupRow = row;
}

- (void)categoryTableViewClick:(NSInteger)row
{
    _categoryRow = row;
}

- (void)stateTableViewClick:(NSInteger)row
{
    _stateRow = row;
}

- (void)timeTableViewClick:(NSInteger)row
{
    _timeRow = row;
}


#pragma mark - TaxisDelegate
- (void)timeChange:(UIButton *)sender
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSArray *queryOrders;
    if (sender.tag - kTAxisBtnTag == 1) {
        queryOrders = @[];
        
    } else if (sender.tag - kTAxisBtnTag == 2) {
        
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"desc"}];
        
    } else {
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"asc"}];
    }
    
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(20),
                                 @"queryOrders":queryOrders
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    __block QuestionViewController *weakSelf = self;
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = tempArray;
        
        if (_allQuestionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            weakSelf.tableView.delegate = weakSelf;
            weakSelf.tableView.dataSource = weakSelf;
            [weakSelf.tableView reloadData];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        }
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;

    }];

    
    [self closeRedView];
}


#pragma mark - UItableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _allQuestionArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionListTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionListCell];
    if (!cell) {
        cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionListCell];
    }
    cell.question = _allQuestionArray[indexPath.row];
    return cell;
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
    QuestionModel *question = (QuestionModel *)_allQuestionArray[indexPath.row];
    questionDetailVC.questionUuid = question.uuid;
    questionDetailVC.row = indexPath.row;
    [self.navigationController pushViewController:questionDetailVC animated:YES];
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 120;
}



- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}


#pragma mark - lazy loading
- (MenuView *)menuView
{
    if (!_menuView) {
        _menuView = [[MenuView alloc] init];
        _menuView.translatesAutoresizingMaskIntoConstraints = NO;
        [_menuView.taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [_menuView.screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:_menuView];
        
        NSLayoutConstraint *menuTop = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:menuTop];
        
        NSLayoutConstraint *menuLeft = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:menuLeft];
        
        NSLayoutConstraint *menuRight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:menuRight];
        
        NSLayoutConstraint *menuHeight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.view addConstraint:menuHeight];
    }
    return _menuView;
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        [self.view addSubview:_tableView];
        [self.view insertSubview:_tableView atIndex:0];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (SearchToolBar *)searchBar
{
    if (!_searchBar) {
        _searchBar = [[SearchToolBar alloc] init];
        _searchBar.translatesAutoresizingMaskIntoConstraints = NO;
        [_searchBar.queryButton addTarget:self action:@selector(searchBarClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.view insertSubview:_searchBar aboveSubview:_tableView];
        [self.view insertSubview:_searchBar aboveSubview:_noDataView];

        
        NSLayoutConstraint *tableHeight = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.view addConstraint:tableHeight];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _searchBar;
}

- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    
    
    if (![self.searchBar.searchTextFiled isExclusiveTouch]) {
        [self.searchBar.searchTextFiled resignFirstResponder];
    }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
