//
//  MoreScreenView.m
//  redstar
//
//  Created by admin on 15/12/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MoreScreenView.h"
#import "GroupItems.h"

#define SELECTED_VIEW_CONTROLLER_TAG 23656534

@interface MoreScreenView ()<GroupTabBarDelegate, UITextViewDelegate>
@property (nonatomic, strong) UIView *backView;
@property (nonatomic, strong) UILabel *placeholderLabel1;
@property (nonatomic, strong) UILabel *placeholderLabel2;
@end

@implementation MoreScreenView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


- (void)setup
{    
    
    self.groupTabBar = [[GroupTabBar alloc] initWithFrame:CGRectMake(0, 0, 100, 350)];
    _groupTabBar.delegate = self;
    [self addSubview:_groupTabBar];
    
    
    
    self.scopeTableView = [[ScopeTableView alloc] init];
    GroupItems *scopeItem = [[GroupItems alloc] initWithTitle:@"问题范围" view:_scopeTableView];
    
    self.groupTableView = [[GroupTableView alloc] init];
    _groupTableView.groupDeleagte = self.categoryTableView;
    GroupItems *groupItem = [[GroupItems alloc] initWithTitle:@"问题分组" view:_groupTableView];
    
    self.categoryTableView = [[CategoryTableView alloc] init];
    GroupItems *categoryItem = [[GroupItems alloc] initWithTitle:@"问题分类" view:_categoryTableView];
    
    self.textView1 = [[UITextView alloc] init];
    _textView1.delegate = self;
    _textView1.tag = 9991;
    self.placeholderLabel1 = [[UILabel alloc] initWithFrame:CGRectMake(5, 0, 100, 30)];
    self.placeholderLabel1.text = @"请输入标题...";
    self.placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
    self.placeholderLabel1.textColor = kOnLineCellDetailColor;
    [self.textView1 addSubview:self.placeholderLabel1];
    GroupItems *textViewItem1 = [[GroupItems alloc] initWithTitle:@"标题类似于" view:_textView1];

    self.textView2 = [[UITextView alloc] init];
    _textView2.delegate = self;
    _textView2.tag = 9992;
    self.placeholderLabel2 = [[UILabel alloc] initWithFrame:CGRectMake(5, 0, 100, 30)];
    self.placeholderLabel2.text = @"请输入关键字...";
    self.placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
    self.placeholderLabel2.textColor = kOnLineCellDetailColor;
    [self.textView2 addSubview:self.placeholderLabel2];
    GroupItems *textViewItem2 = [[GroupItems alloc] initWithTitle:@"关键字类似于" view:_textView2];
    
    self.stateTableView = [[StateTableView alloc] init];
    GroupItems *stateItem = [[GroupItems alloc] initWithTitle:@"问题状态" view:_stateTableView];
    
    self.timeTableView = [[TimeTableView alloc] init];
    GroupItems *timeItem = [[GroupItems alloc] initWithTitle:@"时间段" view:_timeTableView];
    
    [self insertSubview:_scopeTableView belowSubview:_groupTabBar];
    [self insertSubview:_groupTableView belowSubview:_groupTabBar];
    [self insertSubview:_categoryTableView belowSubview:_groupTabBar];
    [self insertSubview:_textView1 belowSubview:_groupTabBar];
    [self insertSubview:_textView2 belowSubview:_groupTabBar];
    [self insertSubview:_stateTableView belowSubview:_groupTabBar];
    [self insertSubview:_timeTableView belowSubview:_groupTabBar];
    
    _groupTabBar.items = @[scopeItem, groupItem, categoryItem, textViewItem1, textViewItem2, stateItem, timeItem];
    [_groupTabBar showIndex:0];
    
    self.backView.backgroundColor = [UIColor whiteColor];
    [self.resetBtn setTitle:@"重置" forState:UIControlStateNormal];
    [self.submitBtn setTitle:@"提交" forState:UIControlStateNormal];
    
}


- (void)switchView:(UIView *)view
{
    UIView *currentView = [self viewWithTag:SELECTED_VIEW_CONTROLLER_TAG];
    [currentView removeFromSuperview];
    currentView = nil;
    
    view.frame = CGRectMake(self.groupTabBar.frame.size.width,0,kScreenWidth - self.groupTabBar.frame.size.width, self.groupTabBar.size.height);
    
    view.tag = SELECTED_VIEW_CONTROLLER_TAG;
    
    [self insertSubview:view belowSubview:_groupTabBar];
    
}

- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc] init];
        _backView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backView];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.groupTabBar attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineViewLeft];
    }
    return _backView;
}

- (UIButton *)resetBtn
{
    if (!_resetBtn) {
        _resetBtn = [[UIButton alloc] init];
        _resetBtn.backgroundColor = [UIColor grayColor];
        _resetBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _resetBtn.layer.cornerRadius = 4.0;
        [self.backView addSubview:_resetBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7.5];
        [self.backView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-20];
        [self.backView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.backView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.backView addConstraint:lineViewLeft];
    }
    return _resetBtn;
}

- (UIButton *)submitBtn
{
    if (!_submitBtn) {
        _submitBtn = [[UIButton alloc] init];
        _submitBtn.backgroundColor = kNavigationBarColor;
        _submitBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _submitBtn.layer.cornerRadius = 4.0;
        [self.backView addSubview:_submitBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7.5];
        [self.backView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.backView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.backView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:20];
        [self.backView addConstraint:lineViewLeft];
    }
    return _submitBtn;
}

#pragma mark - UITextView Delegate
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if (![text isEqualToString:@""]) {
        if (textView.tag == 9991) {
            self.placeholderLabel1.hidden = YES;
        } else {
            self.placeholderLabel2.hidden = YES;
        }
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        if (textView.tag == 9991) {
            self.placeholderLabel1.hidden = NO;
        } else {
            self.placeholderLabel2.hidden = NO;
        }
    }
    
    if ([text isEqualToString:@"\n"]) {
        [self.textView1 resignFirstResponder];
        [self.textView2 resignFirstResponder];
        
        if (textView.tag == 9991) {
            if (textView.text.length != 0) {
                self.placeholderLabel1.hidden = YES;
            } else {
                self.placeholderLabel1.hidden = NO;
            }
        } else {
            if (textView.text.length != 0) {
                self.placeholderLabel2.hidden = YES;
            } else {
                self.placeholderLabel2.hidden = NO;
            }
        }
        return NO;
    }
    
    return YES;
}

@end
