//
//  MacroDefinition.h
//  Palmwms
//
//  Created by 曹云霄 on 16/8/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#ifndef MacroDefinition_h
#define MacroDefinition_h



/**
 *  Documents路径
 */
#define PathDocument  [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0]

/**
 * 读取本地图片路径
 */
#define LOADIMAGE(file) [UIImage imageWithContentsOfFile:file]

/**
 * 读取本地图片路径有缓存
 */
#define LOADIMAGENAME(file)  [UIImage imageNamed:file]

/**
 * 字体大小
 */
#define FontSize(num)           [UIFont systemFontOfSize:num]

/**
 * Window
 */
#define AppWindow               [[UIApplication sharedApplication].delegate window]

/**
 * RGB颜色
 */
#define RGBA(R,G,B,A)           [UIColor colorWithRed:R/255.0f green:G/255.0f blue:B/255.0f alpha:A]

/**
 * 屏幕尺寸
 */
#define ScreenSize              ([[UIScreen mainScreen] bounds].size)

/**
 *  弱引用
 */
#define WS(weakSelf)  __weak __typeof(&*self)weakSelf = self


///**
// *  服务器正式地址
// */
//#define SERVERREQUESTURL(URL)  [NSString stringWithFormat:@"http://122.228.134.82:8180/palmwms-web/app/%@",URL]

/**
 *  服务器开发地址
 */
#define SERVERREQUESTURL(URL)  [NSString stringWithFormat:@"http://139.196.195.30:8091/palmwms-web/app/%@",URL]

/**
 *  断网标示
 */
#define BROKENNETWORK @"-1"

/**
 *  断网提示
 */
#define NETWORK @"网络链接已断开"

/**
 *  AppDelegate代理
 */
#define SHARED_APPDELEGATE ((AppDelegate *)([UIApplication sharedApplication].delegate))

/**
 主题色
 */
#define MainColor   RGBA(30, 115, 181, 1)

/**
 百度地图KEY
 */
#define BAIDUMAPKEY @"qwaIDu5SBOWbjeDKeG46V2ax9nWWrglr"

/**
 保存账号密码serviceName
 */
#define SERVICENAME @"Palmwms"

/**
 保存账号key
 */
#define SAVEACCOUNT @"account"

/**
 保存密码key
 */
#define SAVEPASSWORD @"passWord"


#endif /* MacroDefinition_h */
