//
//  UILabel+CalculateSize.h
//  Palmwms
//
//  Created by 曹云霄 on 16/8/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UILabel (CalculateSize)

/**
 *  计算显示字符串所需宽度
 *
 *  @param text 文本
 *  @param font 字体大小
 *
 *  @return 宽度
 */
+ (CGFloat)CalculateSizeWithText:(NSString *)text withFont:(UIFont *)font withHeight:(CGFloat)height;


/**
 *  计算显示字符串所需高度
 *
 *  @param text 文本
 *  @param font 字体大小
 *
 *  @return 宽度
 */
+ (CGFloat)CalculateSizeWithText:(NSString *)text withFont:(UIFont *)font withWidth:(CGFloat)width;

@end
