//
//  AppDelegate.m
//  Palmwms
//
//  Created by 曹云霄 on 16/8/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AppDelegate.h"
#import "BaseViewController.h"
#import "LoginViewController.h"
#import <BaiduMapAPI_Map/BMKMapComponent.h>

@interface AppDelegate ()
{
    BMKMapManager* _mapManager;
}
@end



@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    
    [[UIApplication sharedApplication] setIdleTimerDisabled:YES];//保持屏幕常亮
    [self detectionNetwork];
    [self setIQKeyboardManager];
    [self startBaiduMapManager];
    [self setRootViewController];
    return YES;
}

#pragma mark - 键盘
- (void)setIQKeyboardManager
{
    IQKeyboardManager *manager = [IQKeyboardManager sharedManager];
    [[IQKeyboardManager sharedManager]setKeyboardDistanceFromTextField:0];
    manager.enable = YES;
    manager.shouldResignOnTouchOutside = YES;
}


#pragma mark -检测网络的可连接性
- (void)detectionNetwork
{
    self.Networkstatus = true;
    [[AFNetworkReachabilityManager sharedManager] startMonitoring];
    [[AFNetworkReachabilityManager sharedManager] setReachabilityStatusChangeBlock:^(AFNetworkReachabilityStatus status) {
        
        switch (status) {
                
            case AFNetworkReachabilityStatusUnknown:
            case AFNetworkReachabilityStatusNotReachable:{
                
                NSLog(@"无网络");
                self.Networkstatus = false;
                break;
            }
            case AFNetworkReachabilityStatusReachableViaWiFi:{
                
                NSLog(@"WiFi网络");
                self.Networkstatus = true;
                break;
                
            }
            case AFNetworkReachabilityStatusReachableViaWWAN:{
                
                NSLog(@"流量网络");
                self.Networkstatus = true;
                break;
            }
            default:
                break;
        }
    }];
}

#pragma mark - 根视图控制器
- (void)setRootViewController
{
    //状态栏白色
    [[UIApplication sharedApplication] setStatusBarStyle:UIStatusBarStyleLightContent animated:NO];
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"PalmwmsMain" bundle:nil];
    LoginViewController *login = [storyboard instantiateViewControllerWithIdentifier:@"LoginViewController"];
    self.window.rootViewController = login;
}

#pragma mark - 启动百度地图
- (void)startBaiduMapManager
{
    // 要使用百度地图，请先启动BaiduMapManager
    _mapManager = [[BMKMapManager alloc]init];
    BOOL ret = [_mapManager start:BAIDUMAPKEY generalDelegate:self];
    if (!ret) {
        NSLog(@"百度地图启动失败");
    }
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
     [[NSNotificationCenter defaultCenter] postNotificationName:UPLOADVERSION object:nil];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end
