
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  排序方向。
 *
 *  @author Debenson
 *  @since 0.0.1
 */
/**
 * 升序
 */
extern NSString * const QUERYORDERDIRECTION_ASC;
/**
 * 降序
 */
extern NSString * const QUERYORDERDIRECTION_DESC;




@class ExceptionCode;
@class RsResponse;
@class BusbillDtl;
@class QueryDefinition;
@class RsQueryResult;
@class Customer;
@class Depot;
@class QueryResultPaging;
@class Distance;
@class Driver;
@class LoginResult;
@class ResetPasswordRequest;
@class ModifyPasswordRequest;
@class LoginRequest;
@class QueryOrder;
@class Busbill;
@class CustomerQueryDefintion;
@class DepotQueryDefintion;
@class DistanceQueryDefintion;
@class DistanceQueryResult;
@class DepotQueryResult;
@class CustomerQueryResult;
@class BusbillQueryResult;
@class BusbillQueryDefintion;
@class BusbillDtlQueryResult;
@class BusbillDtlQueryDefintion;

@protocol ExceptionCode @end
@protocol RsResponse @end
@protocol BusbillDtl @end
@protocol QueryDefinition @end
@protocol RsQueryResult @end
@protocol Customer @end
@protocol Depot @end
@protocol QueryResultPaging @end
@protocol Distance @end
@protocol Driver @end
@protocol LoginResult @end
@protocol ResetPasswordRequest @end
@protocol ModifyPasswordRequest @end
@protocol LoginRequest @end
@protocol QueryOrder @end
@protocol Busbill @end
@protocol CustomerQueryDefintion @end
@protocol DepotQueryDefintion @end
@protocol DistanceQueryDefintion @end
@protocol DistanceQueryResult @end
@protocol DepotQueryResult @end
@protocol CustomerQueryResult @end
@protocol BusbillQueryResult @end
@protocol BusbillQueryDefintion @end
@protocol BusbillDtlQueryResult @end
@protocol BusbillDtlQueryDefintion @end


/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) NSInteger code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */



/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */



/**
 *  出车单明细。
 
 @author Debenson
 @since 0.1
 
 */
@interface BusbillDtl : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 客户标识
 *
 *
 */
@property (nonatomic, copy) NSString *customerUuid;
/**
 * 客户代码
 *
 *
 */
@property (nonatomic, copy) NSString *customerCode;
/**
 * 客户名称
 *
 *
 */
@property (nonatomic, copy) NSString *customerName;
/**
 * 客户精度
 *
 *
 */
@property (nonatomic, copy) NSString *customerLng;
/**
 * 客户纬度
 *
 *
 */
@property (nonatomic, copy) NSString *customerLat;
/**
 * 单据状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 客户地址
 *
 *
 */
@property (nonatomic, copy) NSString *customerAddress;
@end /* interface BusbillDtl */



/**
 *  查询定义。
 
 <br>
 查询定义的基类，具体查询条件由子类实现。
 
 @author Debenson
 @since 0.1
 
 */
@interface QueryDefinition : JSONModel
/**
 * 排序条件
 * @see QueryOrder
 *
 */
@property (nonatomic, strong) NSArray<QueryOrder> *orders;
/**
 * 页数，表示查询第几页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageNumber;
/**
 * 每页的记录数，传0表示查询所有数据不分页
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
@end /* interface QueryDefinition */



/**
 *  查询结果。
 
 <br>
 查询结果基类， 具体结果集合由子类定义。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface RsQueryResult : JSONModel
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) QueryResultPaging *paging;
/**
 * 当前页数
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface RsQueryResult */



/**
 *  客户。
 
 @author Debenson
 @since 0.1
 
 */
@interface Customer : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 地址
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 经度
 *
 *
 */
@property (nonatomic, copy) NSString *lng;
/**
 * 纬度
 *
 *
 */
@property (nonatomic, copy) NSString *lat;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
@end /* interface Customer */



/**
 *  客户。
 
 @author Debenson
 @since 0.1
 
 */
@interface Depot : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 经度
 *
 *
 */
@property (nonatomic, copy) NSString *lng;
/**
 * 纬度
 *
 *
 */
@property (nonatomic, copy) NSString *lat;
@end /* interface Depot */



/**
 *  分页数据。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryResultPaging : JSONModel
/**
 * 当前页数，起始于0
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * 每页记录数，传0表示查询所有记录
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * 查询结果总页数
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * 查询结果总记录数
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
@end /* interface QueryResultPaging */



/**
 *  客户间距离。
 
 @author Debenson
 @since 0.1
 
 */
@interface Distance : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 出发地代码
 *
 *
 */
@property (nonatomic, copy) NSString *startCustomerCode;
/**
 * 目的地代码
 *
 *
 */
@property (nonatomic, copy) NSString *endCustomerCode;
/**
 * 距离
 *
 *
 */
@property (nonatomic, assign) double distance;
@end /* interface Distance */



/**
 *  司机
 
 @author Debenson
 @since 0.1
 
 */
@interface Driver : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface Driver */



/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 * 司机信息
 *
 *
 */
@property (nonatomic, strong) Driver *driver;
@end /* interface LoginResult */



/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 用户编码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 短信验证码，请先调用发送短信接口
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */



/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 司机标识。
 *
 *
 */
@property (nonatomic, copy) NSString *driverId;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */



/**
 *  司机登录请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginRequest : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 密码
 *
 *
 */
@property (nonatomic, copy) NSString *password;
@end /* interface LoginRequest */



/**
 *  查询排序条件。
 
 @author Debenson
 @since 0.0.1
 
 */
@interface QueryOrder : JSONModel
/**
 * 字段名称
 *
 *
 */
@property (nonatomic, copy) NSString *field;
/**
 * 排序方向
 *
 * 取值: QUERYORDERDIRECTION_ASC, QUERYORDERDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *direction;
@end /* interface QueryOrder */



/**
 *  出车单。
 
 @author Debenson
 @since 0.1
 
 */
@interface Busbill : JSONModel
/**
 * 标识
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 送货日期
 *
 *
 */
@property (nonatomic, copy) NSString *pickingDate;
/**
 * 司机信息
 *
 *
 */
@property (nonatomic, copy) NSString *driverInfo;
/**
 * 车辆信息
 *
 *
 */
@property (nonatomic, copy) NSString *busInfo;
/**
 * 单据状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 出车单明细
 * @see BusbillDtl
 *
 */
@property (nonatomic, strong) NSArray<BusbillDtl> *dtls;
@end /* interface Busbill */



/**
 *  客户查询定义。
 
 @author Debenson
 @since 0.1
 
 */
@interface CustomerQueryDefintion : QueryDefinition
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *codeEqualsOrNameLike;
@end /* interface CustomerQueryDefintion */



/**
 *  客户查询定义。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotQueryDefintion : QueryDefinition
@end /* interface DepotQueryDefintion */



/**
 *  客户查询定义。
 
 @author Debenson
 @since 0.1
 
 */
@interface DistanceQueryDefintion : QueryDefinition
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *codeEqualsOrNameLike;
@end /* interface DistanceQueryDefintion */



/**
 *  客户查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface DistanceQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see Distance
 *
 */
@property (nonatomic, strong) NSArray<Distance> *records;
@end /* interface DistanceQueryResult */



/**
 *  客户查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see Depot
 *
 */
@property (nonatomic, strong) NSArray<Depot> *records;
@end /* interface DepotQueryResult */



/**
 *  客户查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface CustomerQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see Customer
 *
 */
@property (nonatomic, strong) NSArray<Customer> *records;
@end /* interface CustomerQueryResult */



/**
 *  出车单查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface BusbillQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see Busbill
 *
 */
@property (nonatomic, strong) NSArray<Busbill> *records;
@end /* interface BusbillQueryResult */



/**
 *  出车单查询定义。
 
 @author Debenson
 @since 0.1
 
 */
@interface BusbillQueryDefintion : QueryDefinition
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *driverCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *date;
@end /* interface BusbillQueryDefintion */



/**
 *  出车单明细查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface BusbillDtlQueryResult : RsQueryResult
/**
 * 查询结果集合
 * @see BusbillDtl
 *
 */
@property (nonatomic, strong) NSArray<BusbillDtl> *records;
@end /* interface BusbillDtlQueryResult */



/**
 *  出车单明细查询定义。
 
 @author Debenson
 @since 0.1
 
 */
@interface BusbillDtlQueryDefintion : QueryDefinition
@end /* interface BusbillDtlQueryDefintion */


