//
//  UserViewController.m
//  Palmwms
//
//  Created by 曹云霄 on 16/8/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "UserViewController.h"
#import "ChangePasswordTableViewCell.h"
#import "LogoutTableViewCell.h"

@interface UserViewController ()<UITableViewDelegate,UITableViewDataSource>

/**
 * 用户tableView
 */
@property (weak, nonatomic) IBOutlet UITableView *userTableView;

/**
 *  用户名
 */
@property (weak, nonatomic) IBOutlet UILabel *userNameLabel;

/**
 *  code
 */
@property (weak, nonatomic) IBOutlet UILabel *passWordLabel;

/**
 *  头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *headerImageView;



@end

@implementation UserViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    [self customBackButton:@selector(backButtonClick:)];
    self.userTableView.tableFooterView = [UIView new];
    self.userNameLabel.text = [NSString stringWithFormat:@"用户名：%@",[UserInforMation manager].userName];
    self.passWordLabel.text = [NSString stringWithFormat:@"代码：%@",[UserInforMation manager].userCode];
}


#pragma mark - <UITableViewDataSource,UITableViewDelegate>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0 && indexPath.section == 0) {
        ChangePasswordTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ChangePasswordTableViewCell" forIndexPath:indexPath];
        return cell;
    }
    LogoutTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"LogoutTableViewCell" forIndexPath:indexPath];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

-(CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0) {
        return 30;
    }
    return 60;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (indexPath.section == 1) {
        
        WS(weakSelf);
        [self showSheetViewWithMessage:@"请确认是否注销账号?" complete:^{
            [[weakSelf class] deleteAccountAndPassWord];
            self.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
            [self dismissViewControllerAnimated:YES completion:nil];
        }];
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/


#pragma mark - 返回
- (void)backButtonClick:(UIButton *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

@end
