//
//  ChangepassWordTableViewController.m
//  Palmwms
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ChangepassWordTableViewController.h"
#import "MBProgressHUD.h"
@interface ChangepassWordTableViewController ()

/**
 *  当前密码
 */
@property (weak, nonatomic) IBOutlet UITextField *oldPassWordTextField;

/**
 *  新密码
 */
@property (weak, nonatomic) IBOutlet UITextField *NewPassWordTextField;

/**
 *  确认新密码
 */
@property (weak, nonatomic) IBOutlet UITextField *sureNewPassWordTextField;

/**
 *  确认修改
 */
@property (weak, nonatomic) IBOutlet UIButton *sureChangeButton;



@end

@implementation ChangepassWordTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self customBackButton:@selector(backButtonClick:)];
    [self uiConfigAction];
}

#pragma mark - 自定义返回按钮
- (void)customBackButton:(SEL)backButtonClick
{
    UIBarButtonItem *backButton = [[UIBarButtonItem alloc]initWithImage:LOADIMAGENAME(@"back") style:UIBarButtonItemStyleDone target:self action:backButtonClick];
    self.navigationItem.leftBarButtonItem = backButton;
}

#pragma mark - UI
- (void)uiConfigAction
{
    [self.sureChangeButton addCorners];
}

#pragma mark - 确认修改密码
- (IBAction)changePassWordButtonClickAction:(UIButton *)sender {
    
    if (![self.oldPassWordTextField.text length]) {
        [self SHOWPrompttext:@"当前密码不能为空"];return;
    }
    if (![self.NewPassWordTextField.text length]) {
        [self SHOWPrompttext:@"新密码不能为空"];return;
    }
    if (![self.sureNewPassWordTextField.text length]) {
        [self SHOWPrompttext:@"确认新密码不能为空"];return;
    }
    if (![self.NewPassWordTextField.text isEqualToString:self.sureNewPassWordTextField.text]) {
        [self SHOWPrompttext:@"两次密码不一致"];return;
    }
    ModifyPasswordRequest *changePassWord = [[ModifyPasswordRequest alloc]init];
    changePassWord.driverId = [UserInforMation manager].userUUid;
    changePassWord.oldPassword = self.oldPassWordTextField.text;
    changePassWord.fnewPassword = self.NewPassWordTextField.text;
    
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(CHANGEPASSWORD) WithRequestType:0 WithParameter:changePassWord WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            //更新账号密码
            [BaseViewController saveAccountAndPassWord:[UserInforMation manager].userName AndPassword:self.NewPassWordTextField.text];
            [weakSelf SuccessMBProgressView:@"密码修改成功" timeDelay:2.0f finish:^{
                [weakSelf.navigationController popViewControllerAnimated:YES];
            }];
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}
#pragma mark -渐隐提示框
- (void)SHOWPrompttext:(NSString *)Text
{
    
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    hud.mode = MBProgressHUDModeText;
    hud.label.text = Text;
    hud.contentColor = MainColor;
    hud.offset = CGPointMake(0.f, MBProgressMaxOffset);
    [hud hideAnimated:YES afterDelay:2.0f];
}

#pragma mark -显示成功的提示框
- (void)SuccessMBProgressView:(NSString *)successString timeDelay:(NSTimeInterval)time finish:(void (^)())complete
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    UIImage *image = [[UIImage imageNamed:@"Checkmark"] imageWithRenderingMode:UIImageRenderingModeAlwaysTemplate];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    hud.customView = imageView;
    hud.contentColor = MainColor;
    hud.label.font = [UIFont systemFontOfSize:18];
    hud.mode = MBProgressHUDModeCustomView;
    hud.label.text = successString;
    [hud hideAnimated:YES afterDelay:time];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(time * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (complete) {
            complete();
        }
    });
}

#pragma mark - 返回
- (void)backButtonClick:(UIBarButtonItem *)item
{
    [self.navigationController popViewControllerAnimated:YES];
}

@end
