//
//  OfflineMapsManager.m
//  Palmwms
//
//  Created by 曹云霄 on 2016/10/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OfflineMapsManager.h"

@implementation OfflineMapsManager

+ (instancetype)manager
{
    static OfflineMapsManager *manager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[OfflineMapsManager alloc]init];
    });
    return manager;
}

- (BMKOfflineMap *)offlineMap
{
    if (!_offlineMap) {
        _offlineMap = [[BMKOfflineMap alloc]init];
        _offlineMap.delegate = self;
    }
    return _offlineMap;
}

/**
 *  定位城市是否支持离线地图
 *
 *  @return BOOL
 */
- (BOOL)isDownloadMaps
{
    NSArray *cityArray = [self.offlineMap getOfflineCityList];
    for (BMKOLSearchRecord *model in cityArray) {
        if ([model.cityName isEqualToString:[UserInforMation manager].city]) {
            return YES;
        }
    }
    return NO;
}

/**
 *  开始下载离线地图
 */
- (void)startDownloadOfflineMaps:(void (^)(BOOL))startState
{
    //根据城市名获取城市信息，得到cityID
    NSArray* city = [_offlineMap searchCity:[UserInforMation manager].city];
    if (city.count > 0) {
        BMKOLSearchRecord* oneCity = [city objectAtIndex:0];
        self.locationCityId = oneCity.cityID;
        if (startState) {
            startState([self.offlineMap start:self.locationCityId]);
        }
    }
}

/**
 *  停止下载离线地图
 */
- (void)pauseDownloadOfflineMaps
{
    [self.offlineMap pause:self.locationCityId];
}

#pragma mark - 下载离线地图回调
- (void)onGetOfflineMapState:(int)type withState:(int)state
{
    if (type == TYPE_OFFLINE_UPDATE) {
        //id为state的城市正在下载或更新，start后会毁掉此类型
        BMKOLUpdateElement *updateInfo = [_offlineMap getUpdateInfo:state];
        if ([self.delegate respondsToSelector:@selector(offlineMapsDownloadProgress:)]) {
            [self.delegate offlineMapsDownloadProgress:updateInfo.ratio/100.0];
        }
        //下载成功
        if ([self.delegate respondsToSelector:@selector(offlineMapsDownloadSuccessOrFailure:)]) {
            [self.delegate offlineMapsDownloadSuccessOrFailure:updateInfo.status];
        }
    }
    if (type == TYPE_OFFLINE_NEWVER) {
        //id为state的state城市有新版本,可调用update接口进行更新
        BMKOLUpdateElement* updateInfo;
        updateInfo = [_offlineMap getUpdateInfo:state];
        NSLog(@"是否有更新%d",updateInfo.update);
    }
    if (type == TYPE_OFFLINE_UNZIP) {
        //正在解压第state个离线包，导入时会回调此类型
    }
    if (type == TYPE_OFFLINE_ZIPCNT) {
        //检测到state个离线包，开始导入时会回调此类型

    }
    if (type == TYPE_OFFLINE_ERRZIP) {
        //有state个错误包，导入完成后会回调此类型
    }
    if (type == TYPE_OFFLINE_UNZIPFINISH) {
        //导入成功state个离线包，导入成功后会回调此类型
    }
    
}


@end
