//
//  OfflineMapsManager.h
//  Palmwms
//
//  Created by 曹云霄 on 2016/10/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduMapAPI_Map/BMKMapComponent.h>


@protocol OfflineMapsManagerDelegate <NSObject>

@optional
/**
 *  离线地图下载状态
 */
- (void)offlineMapsDownloadSuccessOrFailure:(int)state;

/**
 *  离线地图下载进度
 */
- (void)offlineMapsDownloadProgress:(double)progress;


@end

@interface OfflineMapsManager : NSObject<BMKOfflineMapDelegate>


@property (nonatomic,weak) id<OfflineMapsManagerDelegate>delegate;
@property (nonatomic,strong) BMKOfflineMap *offlineMap;
@property (nonatomic,assign) int locationCityId;

/**
 *  下载状态
 */
@property (nonatomic,assign) int downLoadState;


+ (instancetype)manager;

/**
 *  定位城市是否支持离线地图
 *
 *  @return BOOL
 */
- (BOOL)isDownloadMaps;

/**
 *  开始下载离线地图
 */
- (void)startDownloadOfflineMaps:(void(^)(BOOL boolValue))startState;

/**
 *  停止下载离线地图
 */
- (void)pauseDownloadOfflineMaps;



@end
