//
//  NaviManager.h
//  Palmwms
//
//  Created by 曹云霄 on 2016/10/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BNCoreServices.h"

@protocol BaiduNaviHelperDelegate <NSObject>

@optional

/**
 *  导航服务初始化失败
 */
- (void)servicesFailedToInitialize;

/**
 *  路径规划失败
 */
- (void)pathPlanningFailure:(NSString *)errorDescribe;

/**
 *  退出导航
 */
- (void)exitNaviCallback;


@end


@interface NaviManager : NSObject<BNNaviUIManagerDelegate,BNNaviRoutePlanDelegate>


@property (nonatomic,weak) id<BaiduNaviHelperDelegate>delegate;

+ (instancetype)manager;

/**
 *  规划路线（成功后开始导航）
 *
 *  @param end   终点坐标
 */
- (void)planningRouteBeforeStartNaviEndNodePoint:(CLLocationCoordinate2D)end;



@end
